
#include "mbed.h"
#include "TCLcd.h"
#include "font.h"

Serial pc(USBTX, USBRX); // tx, rx


signed long TCLcd::search_font_area( unsigned short code )
{
	unsigned short	i;
	
	for(i=0;i<fnt_head.Tnum;i++)
	{
		if( (fnt_head.Block[i].Start<=code) && (fnt_head.Block[i].End>=code) )
		{
			return(i);
		}
	}
	
	return(-1);
}

signed long TCLcd::get_font_pt( unsigned short code ,unsigned char *chr )
{
	signed long font_area;
	unsigned long offset;
	unsigned long addr;
	
	font_area = search_font_area(code);
	
	if(font_area == -1)
	{
		code = 0x81a0;
		font_area = search_font_area(code);
	}
	
	offset = (unsigned long)code - (unsigned long)fnt_head.Block[font_area].Start;
	
	addr = ((unsigned long)font_search_tbl[font_area] + offset) * ((fnt_head.XSize >> 3) * fnt_head.YSize);

	addr += font_head_size;
		
	memcpy( chr ,&font[addr] ,8 );

	return( 0 );
}

int TCLcd::putc(int value)
{
    static unsigned char tmp[2] = { 0 , 0 };
    static int flag = 0;
    
    if (value == '\n')
    {
        _column = 0;
        _row+=8;
        if (_row >= (ENDROW)) {
            _row = 0;
        }
    }
    else if(value == '\r')
    {
    
    }
    else if(flag == 1)
    {
        flag = 0;
        tmp[1] = value;
        putch2( _column , _row , &tmp[0] , BLUE , WHITE );
        _column+=8;
        if (_column >= (ENDCOL)) {
            _column = 0;
            _row+=8;
            if (_row >= (ENDROW)) {
                _row = 0;
            }
        }
    }
    else if((value >= 0x81) && (value <= 0xea))
    {
        tmp[0] = value;
        flag = 1;
    }
    else
    {    
#if 0
        _column++;
        if (_column >= ENDCOL) {
            _column = 0;
            _row++;
            if (_row >= ENDROW) {
                _row = 0;
            }
        }
#endif
    }
    return value;
}


unsigned short TCLcd::putch2( short x, short y, unsigned char* c, unsigned short fg, unsigned short bg)
{
	unsigned char i,j;
	unsigned short select[2] = { bg , fg };
	unsigned short tmp;
	unsigned char chr[8];
	
	tmp = c[0];
	
	tmp <<= 8;
	
	tmp |= c[1];
	
	    pc.printf( " dat = %02x \r",tmp);
	
	get_font_pt(tmp,&chr[0]);
		
	for(i=0;i<8;i+=1)
	{
		for(j=0;j<8;j++)
		{
			lcd_Pixel(x+j, y+i, select[((chr[i] >> (7-j)) & 0x01)]);
		}
	}
	x += 8;
	return x;
}

TCLcd::TCLcd(PinName db10 ,PinName db11 ,PinName db12 ,PinName db13 ,PinName db14 ,PinName db15 ,PinName db16 ,PinName db17 ,
             PinName wr ,PinName rs ,PinName cs ,PinName reset) : _bus( db10,db11,db12,db13,db14,db15,db16,db17 ) , _wr(wr),_rs(rs),_cs(cs),_reset(reset)
{
    int i;
    wait_ms(20);
    
    _cs = 1;
    _wr = 1;
    _reset = 0;
    wait_ms(1);
    _reset = 1;
    wait_ms(25); 
    
    lcd_out(0x00E3, 0x3008);     // Set internal timing
    lcd_out(0x00E7, 0x0012);     // Set internal timing
    lcd_out(0x00EF, 0x1231);     // Set internal timing
    lcd_out(0x0001, 0x0000);     // set SS and SM bit
    lcd_out(0x0002, 0x0700);    // set line inversion
    lcd_out(0x0003, 0x1018);    // set GRAM write direction and BGR=1, 16bit color
    lcd_out(0x0004, 0x0000);    // Resize register
    lcd_out(0x0008, 0x0207);    // set the back porch and front porch
    lcd_out(0x0009, 0x0000);    // set non-display area refresh cycle ISC[3:0]
    lcd_out(0x000A, 0x0000);    // FMARK function
    lcd_out(0x000C, 0x0000);     // RGB interface setting
    lcd_out(0x000D, 0x0000);    // Frame marker Position
    lcd_out(0x000F, 0x0000);    // RGB interface polarity
    /********* power on seq **************/
    lcd_out(0x0010, 0x0000);     // SAP, BT[3:0], AP[2:0], DSTB, SLP, STB
    lcd_out(0x0011, 0x0007);    // DC1[2:0], DC0[2:0], VC[2:0]
    lcd_out(0x0012, 0x0000);    // VREG1OUT voltage
    lcd_out(0x0013, 0x0000);     // VDV[4:0] for VCOM amplitude
    wait_ms(200);
    lcd_out(0x0010, 0x1490);     // SAP, BT[3:0], AP[2:0], DSTB, SLP, STB
    lcd_out(0x0011, 0x0227);     // R11h=0x0221 at VCI=3.3V ,DC1[2:0], DC0[2:0], VC[2:0]
    wait_ms(50);
    lcd_out(0x0012, 0x001c);     // External reference voltage= Vci;
    wait_ms(50);
    lcd_out(0x0013, 0x0A00);     // R13=0F00 when R12=009E;VDV[4:0] for VCOM amplitude
    lcd_out(0x0029, 0x000F);     // R29=0019 when R12=009E;VCM[5:0] for VCOMH//0012//
    lcd_out(0x002B, 0x000D);     // Frame Rate = 91Hz
    wait_ms(50);
    lcd_out(0x0020, 0x0000);     // GRAM horizontal Address
    lcd_out(0x0021, 0x0000);     // GRAM Vertical Address
    /********** gammer  **********/
    lcd_out(0x0030, 0x0000);
    lcd_out(0x0031, 0x0203);
    lcd_out(0x0032, 0x0001);
    lcd_out(0x0035, 0x0205);
    lcd_out(0x0036, 0x030C);
    lcd_out(0x0037, 0x0607);
    lcd_out(0x0038, 0x0405);
    lcd_out(0x0039, 0x0707);
    lcd_out(0x003C, 0x0502);
    lcd_out(0x003D, 0x1008);
    /*********** GRAM  *********/
    lcd_out(0x0050, 0x0000);     // Horizontal GRAM Start Address
    lcd_out(0x0051, 0x00EF);     // Horizontal GRAM End Address
    lcd_out(0x0052, 0x0000);     // Vertical GRAM Start Address
    lcd_out(0x0053, 0x013F);     // Vertical GRAM Start Address
    lcd_out(0x0060, 0xA700);     // Gate Scan Line wide dsp
    lcd_out(0x0061, 0x0001);     // NDL,VLE, REV
    lcd_out(0x006A, 0x0000);     // set scrolling line
    /************* bubun ************/
    lcd_out(0x0080, 0x0000);    // p dsp 1
    lcd_out(0x0081, 0x0000);    // p dsp 1 start addr
    lcd_out(0x0082, 0x0000);    // p dsp 1 end addr
    lcd_out(0x0083, 0x0000);    // p dsp 1
    lcd_out(0x0084, 0x0000);    // p dsp 1 start addr
    lcd_out(0x0085, 0x0000);    // p dsp 1 end addr
    /************** panel ************/
    lcd_out(0x0090, 0x0010);    // 1Line Clock Num
    lcd_out(0x0092, 0x0600);    // Gate Overlap Clock Num
    lcd_out(0x0093, 0x0003);    // Output Timing
    lcd_out(0x0095, 0x0110);    // RGB 1Line Clock Num
    lcd_out(0x0097, 0x0000);    // Output Timing
    lcd_out(0x0098, 0x0000);    // Output Timing
    /***** dsp cont *****/ 
    lcd_out(0x0007, 0x0133);     // 262K color and display ON
    wait_ms(100);
    
    memcpy( &fnt_head , &font[0] , 18);
    font_head_size = 18 + fnt_head.Tnum * 4;
	for (i=0;i<fnt_head.Tnum;i++)
	{
		fnt_head.Block[i].Start = font[19 + i*4];
		fnt_head.Block[i].Start <<= 8;
		fnt_head.Block[i].Start |= font[18 + i*4];
		fnt_head.Block[i].End = font[21 + i*4];
		fnt_head.Block[i].End <<= 8;
		fnt_head.Block[i].End |= font[20 + i*4];
	}
	font_search_tbl[0] = 0;

	for (i=1;i<fnt_head.Tnum;i++)
	{
		font_search_tbl[i] = (fnt_head.Block[i-1].End - fnt_head.Block[i-1].Start + 1) + font_search_tbl[i-1];
	}
    _column = 0;
    _row = 8;
}


void TCLcd::lcd_out(unsigned short index, unsigned short data)
{
    __disable_fault_irq();
    // Index up byte
    _cs = 0;                // CS Low
    _rs = 0;                // Command 
    //_bus = (index & 0xFF00) | (_bus & 0x00FF);
    _bus = index >> 8;
    _wr = 0;                // WR out
    __NOP();
    _wr = 1;
    // Index down byte
    //_bus = ((index<<8)&0xFF00) | (_bus & 0x00FF);
    _bus = index & 0x00FF;
    _wr = 0;                // WR out
    __NOP();
    _wr = 1;
    // Data up byte
    _rs = 1;                // Data 
    //_bus = (data & 0xFF00) | (_bus & 0x00FF);
    _bus = data >> 8;
    _wr = 0;                // WR out
    __NOP();
    _wr = 1;
    // Index down byte
    //_bus = ((data<<8)&0xFF00) | (_bus & 0x00FF);
    _bus = data & 0x00FF;
    _wr = 0;                // WR out
    __NOP();
    _wr = 1;    
    _cs = 1;                // CS High
    __enable_fault_irq();
}


// DSP Clear
void TCLcd::lcd_Clear(unsigned short Color)
{
    int i, j;
    
    lcd_out(0x0020, 0);                // base set
    lcd_out(0x0021, 0);
    for(    j=0; j<ENDROW; j++){    // Y all
        for(i=0; i<ENDCOL; i++){    // X all
            lcd_out(0x0022, Color);    // own color
        }
    }
}



/***********************************
*  1pixel
*  (0,0)-(161,131)  
***********************************/
void TCLcd::lcd_Pixel(short Xpos, short Ypos, unsigned short Color)
{

    if((Xpos<ENDCOL) && (Ypos<ENDROW)){
        lcd_out(0x0020, Ypos);            // pos
        lcd_out(0x0021, Xpos);
        lcd_out(0x0022, Color);        // dot dsp
    }
}

/***************************
*  line
***************************/
#define    abs(a)    (((a)>0) ? (a) : -(a))
void TCLcd::lcd_Line(short x0, short y0, short x1, short y1, unsigned short Color)
{
    short steep, t;
    short deltax, deltay, error;
    short x, y;
    short ystep;
    
    y0=ENDROW-y0 -1;                        //
    y1=ENDROW-y1 -1;

    steep = (abs(y1 - y0) > abs(x1 - x0));
    if(steep){
        t = x0; x0 = y0; y0 = t;
        t = x1; x1 = y1; y1 = t;
    }
    if(x0 > x1) {
        t = x0; x0 = x1; x1 = t;
        t = y0; y0 = y1; y1 = t;
    }
    deltax = x1 - x0;                        //
    deltay = abs(y1 - y0);
    error = 0;
    y = y0;
    /// 
    if(y0 < y1) ystep = 1; else ystep = -1;
    /// 
    for(x=x0; x<=x1; x++) {
        if(steep) lcd_Pixel(y,x,Color); else lcd_Pixel(x,y,Color);
        error += deltay;
        if((error << 1) >= deltax) {
            y += ystep;
            error -= deltax;
        }
    }
}

/*************************************
*  circle
**************************************/
void TCLcd::lcd_Circle(int x0, int y0, int r, unsigned short color)
{
    int x = r;
    int y = 0;
    int F = -2 * r + 3;
    
    while(x >= y){
        lcd_Pixel(x0+x, y0+y, color);
        lcd_Pixel(x0-x, y0+y, color);        
        lcd_Pixel(x0+x, y0-y, color);
        lcd_Pixel(x0-x, y0-y, color);        
        lcd_Pixel(x0+y, y0+x, color);
        lcd_Pixel(x0-y, y0+x, color);        
        lcd_Pixel(x0+y, y0-x, color);
        lcd_Pixel(x0-y, y0-x, color);
        if(F >= 0){
            x--;
            F -= 4 * x;
        }
        y++;
        F += 4 * y + 2;
    }
}
#if 0
/*****************************************
*  char dsp
******************************************/
void TCLcd::lcd_Char(char colum, char line, unsigned char letter, unsigned short Color1, unsigned short Color2){
    unsigned char j, i, Mask;

    if((colum < XChar) && (line < YLine)){        // 
        // 
        for(j=0; j<6; j++){
            // 
            Mask = 0x80;
            for(i=0; i<8; i++){
                // 
                if((ANKFont[letter][j*3] & Mask) != 0)
                    lcd_Pixel(colum*12+i+4, line*14+j*2+2, Color1);
                else
                    lcd_Pixel(colum*12+i+4, line*14+j*2+2, Color2);     //
                // 
                if((ANKFont[letter][j*3+2] & Mask) != 0)
                    lcd_Pixel(colum*12+i+8, line*14+j*2+3, Color1);
                else
                    lcd_Pixel(colum*12+i+8, line*14+j*2+3, Color2);     //
                Mask = Mask >> 1;
            }
            // 
            Mask = 0x80;
            // 
            for(i=0; i<4; i++){
                if((ANKFont[letter][j*3+1] & Mask) != 0)
                    lcd_Pixel(colum*12+i+12, line*14+j*2+2, Color1);
                else
                    lcd_Pixel(colum*12+i+12, line*14+j*2+2, Color2);     //
                Mask = Mask >> 1;
            }
            // 
            for(i=4; i<8; i++){
                if((ANKFont[letter][j*3+1] & Mask) != 0)
                    lcd_Pixel(colum*12+i, line*14+j*2+3, Color1);
                else
                    lcd_Pixel(colum*12+i, line*14+j*2+3, Color2);     //
                Mask = Mask >> 1;
            }                            
        }
    }
}
/******************************
*   str dsp
******************************/
void TCLcd::lcd_Str(char colum, char line, char *s, unsigned short Color1, unsigned short Color2)
{
        while (*s){
        lcd_Char(colum++, line, *s++, Color1, Color2);
        if(colum >= XChar){
            line++;
            colum = 0;
            if(line >= YLine)
                line = 0;
        }
    }
}

#endif