#ifndef MBED_TCLCD_H
#define MBED_TCLCD_H

#include "mbed.h"

#define ENDCOL     320    // X
#define ENDROW     280    // Y
#define WHITE        0xFFFF
#define BLACK        0x0000
#define RED        0xF800
#define GREEN        0x07E0
#define BLUE        0x001F
#define CYAN        0x07FF
#define MAGENTA    0xF81F
#define YELLOW    0xFFE0
#define BROWN        0x8000
#define ORANGE    0xFC00
#define PERPLE    0x8010
#define COBALT    0x041F

typedef struct {
    char Identifier[6];			// "FONTX2"という文字列が入る
    char FontName[8];			// Font名(8文字)
    unsigned char XSize;		// フォントの横幅
    unsigned char YSize;		// フォントの高さ
    unsigned char CodeType;		// 0x01
    unsigned char Tnum;			// 文字コードテーブルのエントリ数 0x58
    struct {
		unsigned short Start;			// 領域の始まりの文字コード
		unsigned short End;				// 領域の終わりの文字コード
    } Block[100];					// Tnum個続く
} FONT_HEAD;

class TCLcd {
public:
    
    TCLcd(PinName db10 ,PinName db11 ,PinName db12 ,PinName db13 ,PinName db14 ,PinName db15 ,PinName db16 ,PinName db17 ,
          PinName wr ,PinName rs ,PinName cs ,PinName reset );
    
    void lcd_Clear(unsigned short Color);
    void lcd_Pixel(short Xpos, short Ypos, unsigned short Color);
    void lcd_Line(short x0, short y0, short x1, short y1, unsigned short Color);
    void lcd_Circle(int x0, int y0, int r, unsigned short color);
    unsigned short putch2( short x, short y, unsigned char* c, unsigned short fg, unsigned short bg);
    int putc(int value);
protected:
    BusOut       _bus;
    DigitalOut _wr;
    DigitalOut _rs;
    DigitalOut _cs;
    DigitalOut _reset;
    signed long search_font_area( unsigned short code );
    signed long get_font_pt( unsigned short code ,unsigned char *chr );
    FONT_HEAD fnt_head;
    unsigned short font_head_size;
    unsigned short font_search_tbl[100];
    short _column;
    short _row;
    void lcd_out(unsigned short index, unsigned short data);

};



#endif