#include "mbed.h"
#include "MQTTInterface.h"
#include "MQTTClient.h"
#include "Milkcocoa.h"
#include "MClient.h"
#include "EthernetInterface.h"

EthernetInterface eth;
Serial pc(USBTX,USBRX);

/************************* Your Milkcocoa Setup *********************************/

#define MILKCOCOA_APP_ID      "teaidsirehz"
#define MILKCOCOA_DATASTORE   "mbed_lan"

/************* Milkcocoa Setup (you don't need to change this!) ******************/

#define MILKCOCOA_SERVERPORT  1883

/************ Global State (you don't need to change this!) ******************/
const char MQTT_SERVER[]  = MILKCOCOA_APP_ID ".mlkcca.com";
const char MQTT_CLIENTID[] = __TIME__ MILKCOCOA_APP_ID;

extern void onpush(MQTT::MessageData& md);

int main() {
    
    pc.baud(9600);
    pc.printf("Milkcocoa mbed os ver demo\n\r\n\r\n\r");
    
    int ret = eth.connect();
    if (ret != 0) {
        printf("\r\nConnection error\r\n");
        return -1;
    }
    pc.printf("\n\rEthernet connected\n\r");
    
    MQTTInterface* ipstack = new MQTTInterface(&eth);
    MClient* client = new MClient(ipstack);
    Milkcocoa* milkcocoa = new Milkcocoa(client, MQTT_SERVER, MILKCOCOA_SERVERPORT, MILKCOCOA_APP_ID, MQTT_CLIENTID);
    
    milkcocoa->connect();
    
    pc.printf("%d\n\r",milkcocoa->on(MILKCOCOA_DATASTORE, "push", onpush));
    
    milkcocoa->start();

    while(1) {
        
        DataElement elem = DataElement();
        elem.setValue("v", 1);
        
        milkcocoa->push(MILKCOCOA_DATASTORE, elem);
        pc.printf("PUSH\n\r");
        Thread::wait(500);
        
    }
}

void onpush(MQTT::MessageData& md)
{
    MQTT::Message &message = md.message;
    DataElement de = DataElement((char*)message.payload);
    pc.printf("onpush\n\r");
    pc.printf("%d\n\r",de.getInt("v"));
}