#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPServer.h"

EthernetNetIf eth;
HTTPServer svr;
DigitalOut led1(LED1);
DigitalOut led2(LED2, "led2");
AnalogIn ain(p15,"tmp");
LocalFileSystem fs("webfs");

int main() {
    
    printf("Setting up...\n");

    EthernetErr ethErr = eth.setup();

    if(ethErr) {
        printf("Error %d in setup.\n", ethErr);
        return -1;
    }
    printf("Setup OK\n");
    

    FSHandler::mount("/webfs", "/");
    svr.addHandler<RPCHandler>("/rpc");
    svr.addHandler<FSHandler>("/");
    svr.bind(80);

    printf("Listening...\n");

    Timer tm;
    tm.start();

    while(true)
    {
        Net::poll();
        if(tm.read()>.5)
        {
            led1=!led1;
            tm.start();
        }
    }
    return 0;
}