#include "mbed.h"
#include "EthernetNetIf.h"
#include "NTPClient.h"
#include "HTTPClient.h"

#define TMP_TEXT_BUF_SIZE 256 // 文字列用のバッファ・サイズ

// 使用するライブラリの定義
PwmOut beep(p21);
DigitalOut t_p(p29);
DigitalIn touch(p30);
EthernetNetIf eth;
NTPClient ntp;
LocalFileSystem local("local");

// 使用する変数の定義と初期化
char id[32] = "\0";
char password[32] = "\0";
char msg_file_name[32] = "\0";

// 圧電ブザーを鳴らす関数 鳴らす周波数と時間を指定する
void Beep(float freq, float time) {
    beep.period(1.0/freq);
    beep.write(0.5);
    wait(time);
    beep.write(0.0);
}

// タッチを検出する関数 タッチを検出したときにTRUEになる
bool GetTouch(void) {
    int touch_count = 0;
    t_p = 1;
    touch_count = 0;
    
    while((touch != 1)&&(touch_count < 10000))
    {
        touch_count++;
    }
    t_p = 0;
    
    if( touch_count != 10000 ) {
        return(true);
    }
    else {
        return(false);
    }
}

// テキストファイルから1行分を取得する関数
unsigned char GetFileLine( FILE *stm , char *str ) {
    char count = 0;
    if(fread(&str[count], 1,1,stm) > 0) {
        count++;
        while( (fread(&str[count], 1,1,stm) > 0)
            &&(str[count] != '\n')
            &&(count < TMP_TEXT_BUF_SIZE)) {
            count++;
        }
    }
    str[count] = '\0';
    return(count);
}

// 文字列に時間を追加する関数
void StrTimeAdd( char *msg, struct tm *set_time) {
    char tmp[10];
    sprintf(tmp," at %02d:%02d",set_time->tm_hour, set_time->tm_min);
    strcat( msg ,tmp);
}

// 日本時間を取得する関数
struct tm *GetJstTime(void) {
    time_t ctTime;
    ctTime = time(NULL);
    ctTime += 32400;
    return(localtime(&ctTime));
}

// ファイルからタグを検索し，その文字列を取得する関数
int GetStatus( char *path , char *tag , char *text ) {
    char *TmpText = (char*)malloc(TMP_TEXT_BUF_SIZE);
    if( TmpText == NULL ) {
        return( -1 );
    }
    
    char *TmpTag = (char*)malloc(TMP_TEXT_BUF_SIZE);
    
    if( TmpTag == NULL ) {
        free( TmpTag );
        return( -1 );
    }
    
    FILE *stm = fopen( path,"r");
    
    if( stm != NULL ) {
        text[0] = '\0';
        sprintf( TmpTag,"%s:%%s",tag );
        while(GetFileLine( stm , TmpText ) > 0) {
            sscanf( TmpText,TmpTag,text );
        }
        fclose(stm);
    }
    
    free( TmpText );
    free( TmpTag );
    return(0);
}

// ファイルから今の時間と一日のつぶやき数でつぶやく内容を探す関数
int GetTimeMsg( char *path , struct tm *set_time ,char *msg , char day_cnt) {
	int count = 0;
	
	char *TmpText = (char*)malloc(TMP_TEXT_BUF_SIZE);
	if( TmpText == NULL ) {
		return( -1 );
	}
	
	char *GoodText = (char*)malloc(TMP_TEXT_BUF_SIZE);
	if( GoodText == NULL ) {
		free( TmpText );
		return( -1 );
	}
	
	char *BadText = (char*)malloc(TMP_TEXT_BUF_SIZE);
	if( BadText == NULL ) {
		free( TmpText );
		free( GoodText );
		return( -1 );
	}
	
	FILE *stm = fopen( path,"r");
	if( stm != NULL ) {
		char tmp_hour;
		char tmp_min;
		
		GetFileLine(stm,TmpText);
		
		count = 0;
		msg[0] = '\0';
		while((GetFileLine(stm,TmpText) > 0)&&(msg[0] == '\0')) {
			if(sscanf(TmpText,"%d:%d %s %s", &tmp_hour,&tmp_min,GoodText,BadText) > 0) {
				if( day_cnt == count ) {
					if( (set_time->tm_hour * 60 + set_time->tm_min) < (tmp_hour * 60 + tmp_min + 5) ) {
						strcpy(msg,GoodText);
					}
					else {
						strcpy(msg,BadText);
					}
				}
				count++;
			}
		}
		fclose(stm);
	}
	else
	{
		count = -1;
	}
	free( TmpText );
	free( GoodText );
	free( BadText );
	
	return( count );
}

// Twitterへつぶやく関数
bool TwitMsg( char *id , char *password , char *msg) {
	HTTPClient twitter;
	HTTPMap h_msg;
	
	h_msg["status"] = msg;
	
	twitter.basicAuth(id, password);
	HTTPResult r = twitter.post("http://api.supertweet.net/1/statuses/update.xml", h_msg, NULL);
	
	if( r == HTTP_OK ) {
		return(true);
	}
	else {
		return(false);
	}
}

int main() {
	struct tm *jst_time;
	int day_count = 0;
	int old_day = 0;
	
	// 設定ファイルからTwitterのユーザ名，パスワードなどを読み出す．
	GetStatus("/local/env.ini","ID",id);
	GetStatus("/local/env.ini","PASS",password);
	GetStatus("/local/env.ini","FILE",msg_file_name);
	
	EthernetErr ethErr = eth.setup();
	if(ethErr)
	{
		return -1;
	}
	
	if( time(NULL) == -1 ) {
		Host server(IpAddr(), 123, "0.uk.pool.ntp.org");
		ntp.setTime(server);
	}
	
	while(1) {
	
		jst_time = GetJstTime();
		if( jst_time->tm_mday != old_day ) {
			day_count = 0;
		}
		
		old_day = jst_time->tm_mday;
		if( GetTouch() == true ) {
			
			Beep( 2637.020455 , 0.5 );
			
			char *msg = (char*)malloc(TMP_TEXT_BUF_SIZE);
			if( msg != NULL ) {
			
				int result = GetTimeMsg( msg_file_name , jst_time ,msg , day_count );
				if( result != -1 ) {
					day_count = result;
				}
				
				StrTimeAdd( msg , jst_time );
				
				if(TwitMsg( id , password , msg )) {
					Beep( 2637.020455 , 0.5 );
				}
				free( msg );
			}
		}
	}
	return 0;
}

