#include "mbed.h"
#include "EthernetNetIf.h" // Cũwb_Et@CCN[h
#include "HTTPServer.h" // Cũwb_Et@CCN[h

// Cu̒`
EthernetNetIf eth;                      // C[TlbgEC^[tF[X
HTTPServer svr;                         // HTTPT[o
DigitalOut led1(LED1);                  // 쒆\p
DigitalOut led2(LED2, "led2");          // uEUォ爵߂ɖOt
AnalogIn ain(p15,"tmp");                // uEUォ爵߂ɖOt
LocalFileSystem fs("webfs");            // uEUォmbedhCuɃANZX

int main() {
    printf("Setting up...\n");

    EthernetErr ethErr = eth.setup();   // lbg[Nɐڑ

    if(ethErr) {
        // ڑُ
        printf("Error %d in setup.\n", ethErr);
        return -1;
    }
    printf("Setup OK\n");

    // HTTPT[o̐ݒ
    FSHandler::mount("/webfs", "/");
    svr.addHandler<RPCHandler>("/rpc");
    svr.addHandler<FSHandler>("/");
    svr.bind(80);

    printf("Listening...\n");

    Timer tm;
    tm.start();                         // ^C}EX^[g

    while(true)
    {
        Net::poll();                    // lbg[N
        if(tm.read()>.5)                // ^C}EX^[gĂ0.5b珈
        {
            led1=!led1;                 // LED_
            tm.start();                 // ^C}EX^[g
        }
    }
    return 0;
}