#include "mbed.h"
#include "EthernetNetIf.h"
#include "TextLCD.h"
#include "HTTPClient.h"


EthernetNetIf eth; 
HTTPClient http;

int j_paser( const char *buf , char *word , char *out )
{
    int i = 0;
    char *p;
    char _word[64] = "\"\0";

    strcat(_word , word );
    strcat(_word , "\"" );

    p = strstr( (char*)buf , _word ) + 2 + strlen(_word);
    
    while( (p[i] != ',')&&(p[i] != '\n') )
    {
        out[i] = p[i];
        i++;
    }
    out[i] = '\0';
    
    return(i);
}

int main(void) {
    
    char year[32];
    char month[32];
    char day[32];
    char hour[32];
    char usage[32];
    char capacity[32];
    
    EthernetErr ethErr = eth.setup();
    if(ethErr)
    {
        printf("Ethernet err.\r\n");
        return(-1);
    }
    
    printf("Getting info.\r\n");
    
    HTTPText txt;
    
    HTTPResult r = http.get("http://tepco-usage-api.appspot.com/latest.json", &txt);
    
    if(r==HTTP_OK)
    {
        j_paser(txt.gets() , "year" , year);
        j_paser(txt.gets() , "month" , month);
        j_paser(txt.gets() , "day" , day);
        j_paser(txt.gets() , "hour" , hour);
        j_paser(txt.gets() , "usage" , usage);
        j_paser(txt.gets() , "capacity" , capacity);
        
        printf("%s/%s/%s %sh\r\n",year,month,day,hour);
        printf("%s/%s %3.1f%%\r\n",usage,capacity,(((float)atoi(usage)/(float)atoi(capacity))*100.0));
    }
    else
    {
        printf("Http get err.\r\n");
        return(-1);
    }
    
    while(1)
    {
        
    }
    
    return(0);
}
