#include "mbed.h"
#include "EthernetNetIf.h"
#include "TextLCD.h"
#include "HTTPClient.h"

TextLCD lcd(p24, p26, p27, p28, p29, p30); // rs, e, d4-d7

EthernetNetIf eth; 
HTTPClient http;

int j_paser( const char *buf , char *word , char *out )
{
    int i = 0;
    char *p;
    char _word[64] = "\"\0";

    strcat(_word , word );
    strcat(_word , "\"" );

    p = strstr( (char*)buf , _word ) + 2 + strlen(_word);
    
    while( (p[i] != ',')&&(p[i] != '\n') )
    {
        out[i] = p[i];
        i++;
    }
    out[i] = '\0';
    
    return(i);
}

int main(void) {
    
    char year[32];
    char month[32];
    char day[32];
    char hour[32];
    char usage[32];
    char capacity[32];
    
    EthernetErr ethErr = eth.setup();
    if(ethErr)
    {
        lcd.locate(0,0);
        lcd.printf("Ethernet err.");
        return(-1);
    }
    
    lcd.locate(0,0);
    lcd.printf("Getting info.");
    
    HTTPText txt;
    
    HTTPResult r = http.get("http://tepco-usage-api.appspot.com/latest.json", &txt);
    
    if(r==HTTP_OK)
    {
        j_paser(txt.gets() , "year" , year);
        j_paser(txt.gets() , "month" , month);
        j_paser(txt.gets() , "day" , day);
        j_paser(txt.gets() , "hour" , hour);
        j_paser(txt.gets() , "usage" , usage);
        j_paser(txt.gets() , "capacity" , capacity);
        
        lcd.locate(0,0);
        lcd.printf("%s/%s/%s %sh",year,month,day,hour);
        lcd.locate(0,1);
        lcd.printf("%s/%s %3.1f%%",usage,capacity,(((float)atoi(usage)/(float)atoi(capacity))*100.0));
    }
    else
    {
        lcd.locate(0,0);
        lcd.printf("Http get err.");
        return(-1);
    }
    
    while(1)
    {
        
    }
    
    return(0);
}
