#include "mbed.h"
#include "EthernetNetIf.h"
#include "NTPClient.h"
#include "SMTPClient.h"
#include "IniFile.h"
#include "TextLCD.h"

#define HOSTNAME "mbedSE"

#define READ_BUF_SIZE 128

EthernetNetIf eth(HOSTNAME);
DigitalOut led1(LED1, "led1");
DigitalIn sensor(p5);
DigitalIn sw[] = { p13,p14,p9 };
TextLCD lcd(p11, p12, p27, p28, p29, p30);  // rs, e, d4-d7
LocalFileSystem local("local");
Ticker flipper;
IniFile ini("/local/setting.ini");

extern "C" void mbed_reset();

char password[4] = { 1,2,4,1 };
int timecount = 0;

void TimeCount()
{
    if(timecount != 0)    timecount--;
}

int SendMail()
{
    int ini_port;
    char ini_server[READ_BUF_SIZE];
    char ini_domain[READ_BUF_SIZE];
    char ini_user[READ_BUF_SIZE];
    char ini_password[READ_BUF_SIZE];
    
    ini.get("PORT",        ini_port);
    ini.get("SERVER",    ini_server , READ_BUF_SIZE);
    ini.get("DOMAIN",    ini_domain , READ_BUF_SIZE);
    ini.get("USER",        ini_user , READ_BUF_SIZE);
    ini.get("PASSWORD",    ini_password , READ_BUF_SIZE);
    
    Host host(IpAddr(), ini_port, ini_server);
    SMTPClient smtp(host, ini_domain, ini_user, ini_password, SMTP_AUTH_PLAIN);
    
    char ini_from_addr[READ_BUF_SIZE];
    char ini_to_addr[READ_BUF_SIZE];
    char ini_msg[READ_BUF_SIZE];
    
    ini.get("FROM_ADDRESS",    ini_from_addr , READ_BUF_SIZE);
    ini.get("TO_ADDRESS",    ini_to_addr , READ_BUF_SIZE);
    ini.get("MSG",            ini_msg , READ_BUF_SIZE);
    
    time_t ctTime = time(NULL) + 32400;
    
    EmailMessage msg;
    msg.setFrom(ini_from_addr);
    msg.addTo(ini_to_addr);
    msg.printf("Subject: Mail %s", ctime(&ctTime));
    msg.printf("%s",ini_msg);

    printf("Send result %d\n", smtp.send(&msg));
    printf("Last response | %s", smtp.getLastResponse().c_str());
    
    smtp.clearAuth();

    return(0);
}

int CheckInputSw()
{
    static int BeforeSw[3] = { 0,0,0 };
    int NowSw[3];
    int ret = 0;
    
    for(int i=0;i<3;i++)
    {
        NowSw[i] = sw[i];
        
        if((BeforeSw[i])&&(NowSw[i]==0))
        {
            ret |= 0x01 << i;
        }
        
        BeforeSw[i] = NowSw[i];
    }
    
    if(ret != 0)
    {
        wait(0.2);
        
    }
    
    return(ret);
}

bool password_mode()
{
    int input_num = 0;
    char input_button[4] = { 0,0,0,0 };
    
    lcd.locate(0,1);
    lcd.printf("Password? ");
    
    timecount = 5;
    flipper.attach(&TimeCount, 1.0);
    
    while((input_num < 4)&&(timecount!=0))
    {
        lcd.locate(10,0);
        lcd.printf("%dsec",timecount);
        int in = CheckInputSw();
        
        if( in )
        {
            input_button[input_num] = in;
            input_num++;
            lcd.locate(10+input_num,1);
            lcd.printf("*");
        }
    }
    flipper.detach();
    
    if(memcmp( &input_button[0] , &password[0],4) == 0)
    {
        lcd.locate(10,1);
        lcd.printf("  OK  ");
        return(true);
    }
    else
    {
        lcd.locate(10,1);
        lcd.printf("  NG  ");
        return(false);
    }
    
    return(false);
}

int main() {
    
    sensor.mode(PullDown);
    sw[0].mode(PullUp);
    sw[1].mode(PullUp);
    sw[2].mode(PullUp);
    
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("EtherSetting..");
    
    EthernetErr ethErr;
    
    do {
        ethErr = eth.setup();
        if (ethErr) printf("Timeout\n", ethErr);
    } while (ethErr != ETH_OK);
    
    
#if 0
    printf("Connected OK\n");
    const char* hwAddr = eth.getHwAddr();
    printf("HW address : %02x:%02x:%02x:%02x:%02x:%02x\n",
           hwAddr[0], hwAddr[1], hwAddr[2],
           hwAddr[3], hwAddr[4], hwAddr[5]);

    IpAddr ethIp = eth.getIp();
    printf("IP address : %d.%d.%d.%d\n", ethIp[0], ethIp[1], ethIp[2], ethIp[3]);
#endif
    
    // Get time
    NTPClient ntp;
    //printf("NTP setTime...\n");
    Host server(IpAddr(), 123, "pool.ntp.org");
    ntp.setTime(server);
    time_t ctTime = time(NULL) + 32400;
    //printf("\nTime is now (UTC): %d %s\n", ctTime, ctime(&ctTime));

    Timer tm;
    tm.start();
    
    bool checking = false;

    while (true) {
        
        time_t ctTime = time(NULL) + 32400;
        struct tm *timeObject = localtime(&ctTime);
        lcd.locate(0,1);
        lcd.printf("%02d/%02d %02d:%02d:%02d", timeObject->tm_mon,timeObject->tm_mday,timeObject->tm_hour,timeObject->tm_min,timeObject->tm_sec);
        
        if( checking )
        {
            lcd.locate(0,0);
            lcd.printf("Watching Mode");
            if (tm.read() > 0.5) {
                led1 = !led1;
                
                if(sensor)
//                if(CheckInputSw() == 0x04)
                {
                    lcd.cls();
                    lcd.locate(0,0);
                    lcd.printf("Alert On!");
                    if(password_mode())
                    {     
                        wait(0.5);
                    }
                    else
                    {
                        lcd.locate(0,0);
                        lcd.printf("Send Alert Mail!");
                        SendMail();
                        
                        mbed_reset();
                    }
                    checking = false;
                    lcd.cls();
                }
                tm.start();
            }
        }
        else
        {
            lcd.locate(0,0);
            lcd.printf("Free Mode");
            
            if( CheckInputSw() == 0x01 )
            {
                lcd.locate(0,0);
                lcd.printf("Mode Change...");
                checking = true;
                wait(5);
                lcd.cls();
            }
        }
        Net::poll();
    }
}