/*
Copyright (c) 2011 JKSOFT

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#include "mbed.h"
#include "USBHost.h"
#include "Utils.h"
#include "BD6211F.h"
#include "Wiimote.h"


// ----- Wallbot I/O Setting ----- 
// Motor
BD6211F      RightMotor(p21,p22);
BD6211F      LeftMotor(p23,p24);

// Direct control mode
int DirectMode( Wiimote* wii, int stat )
{
    int ret = stat;
    
    if( wii->left )
    {
        RightMotor = 1.0;
        LeftMotor = -1.0;
    }
    else if( wii->right )
    {
        RightMotor = -1.0;
        LeftMotor = 1.0;
    }    
    else if( wii->up )
    {
        RightMotor = 1.0;
        LeftMotor = 1.0;
    }
    else if( wii->down )
    {
        RightMotor = -1.0;
        LeftMotor = -1.0;
    }
    else
    {
        RightMotor = 0.0;
        LeftMotor = 0.0;
    }

    float factor = wii->wheel / 150.0f; 
    
    float left_factor = (factor >= 0.0) ? 1.0 : 1.0 - (-factor);
    float right_factor = (factor <= 0.0) ? 1.0 : 1.0 - factor;
    
    if( wii->one )
    {
        RightMotor = right_factor;
        LeftMotor = left_factor;
    }
    if( wii->two )
    {
        RightMotor = -left_factor;
        LeftMotor = -right_factor;
    }
    
    return(ret);
}

// Processing when receiving it from Wiiremote
int wall_bot_remote(char *c,int stat)
{
    Wiimote wii;
    int ret = stat;
    
    wii.decode(c);
    
    ret = DirectMode( &wii ,ret );
    
    return(ret);
}

int GetConsoleChar()
{
    return(0);
}

int OnDiskInsert(int device)
{
    return(0);
}

int main()
{
    // USB Init is done for Bluetooth
    USBInit();
    
    while(1)
    {
       // USB Processing is done for Bluetooth
       USBLoop();
    }
}
