#ifndef HIGH_SPEED_ANALOG_IN_H
#define HIGH_SPEED_ANALOG_IN_H

#include "mbed.h"

class HighSpeedAnalogIn {
public:

    HighSpeedAnalogIn(PinName pin0, PinName pin1 = NC, PinName pin2 = NC, PinName pin3 = NC, PinName pin4 = NC, PinName pin5 = NC);
    ~HighSpeedAnalogIn();
    float read(PinName pin);
    unsigned short read_u16(PinName pin);

private:

    HighSpeedAnalogIn();
    uint32_t _adc_data[8];

    static const int XTAL_FREQ = 12000000;
    static const int MAX_ADC_CLOCK = 13000000;
    static const int CLKS_PER_SAMPLE = 64;
    
    static HighSpeedAnalogIn *instance;
    static int refcnt;

    static void static_adcisr(void);

    int get_channel(PinName pin);
    uint32_t get_data(PinName pin);
    void adcisr(void);
    void setup(PinName pin, int state);
    void interrupt_state(PinName pin, int state);
};

#endif
