#include "mbed.h"
#include "USBKeyboard.h"
#include "touchpad.h"

#define X0  p17
#define Y0  p20
#define X1  p19
#define Y1  p18

#define KEY_UP      0x80
#define KEY_DOWN    0x81
#define KEY_RIGHT   0x82
#define KEY_LEFT    0x83

USBKeyboard keyboard;

Ticker timer1;
Ticker timer2;
Touchpad tp(X0,X1,Y0,Y1);

int x,y,z;

// Sampling interrupt
void sample(void)
{
  tp.tick();
}

// Touch position acquisition interrupt
void scan_keyboard(void)
{
    // Touch judgment
    if (tp.hotspot()>0)
    {
        x = tp.get_hotspot_x();
        y = tp.get_hotspot_y();
        z = 1;
    }
    else
    {
        z = 0;
    }
}

int main() {
    int befor_z = 0;

    // Sampling interrupt 1 ms.
    timer1.attach_us(&sample,1000);
    // Touch position acquisition interrupt 10 ms.
    timer2.attach_us(&scan_keyboard,10000); 
  
    while (1)
    {
        // The key is transmitted only momentarily at the time of touched. 
        if((z==1)&&(befor_z==0))
        {
            if((x==2)&&(y>=2))
            {
                keyboard.sendKey( KEY_UP );     // Up key
            }
            else if((x==2)&&(y<=1))
            {
                keyboard.sendKey( KEY_DOWN );   // Down key
            }
            else if((x>=3)&&(y==2))
            {
                keyboard.sendKey( KEY_RIGHT );  // Right key
            }
            else if((x<=1)&&(y==2))
            {
                keyboard.sendKey( KEY_LEFT );   // Left key
            }
            else
            {
            
            }
        }
        // The last state of touch is maintained. 
        befor_z = z;
        // The touch position for debugging is output. 
        printf("X = %d\tY = %d\tZ = %d\r\n",x,y,z);
    }
}
