#include "usbhid.h"

#ifndef MBED_USBKEYBOARD_H
#define MBED_USBKEYBOARD_H

/* Class: USBKeyboard
 * Emulate a USB Keyboard HID device
 *
 * Example:
 * > #include "mbed.h"
 * > #include "USBKeyboard.h"
 * > 
 * > USBKeyboard kb;
 * >
 * > int main() {
 * >     while(1) {
 * >         kb.sendKeys("Foo goes here!");
 * >         wait(2);
 * >     }
 * > }
 */
class USBKeyboard : private usbhid {
public:
    /* Constructor: USBKeyboard
     * Create a USB Keyboard using the mbed USB Device interface
     */
    USBKeyboard();

    void sendKeys(char *szString);
    void sendKey(char c);
    

private:

};

#endif