#include "mbed.h"
#include "ESP8266Interface.h"
#include "TCPSocketConnection.h"
#include "ifttt.h"
#include "SoftSerialSendOnry.h"

ESP8266Interface wifi(dp16,dp15,dp4,"SSID","Password",115200); // TX,RX,Reset,SSID,Password,Baud
SoftSerialSendOnry pc(dp10); // tx

int main()
{
    pc.baud(9600);
    wifi.init(); //Reset
    wifi.connect(); //Use DHCP
    pc.printf("IP Address is %s \n\r", wifi.getIPAddress());
    TCPSocketConnection socket;
    
    // Initialize ifttt object, add up to 3 optional values, trigger event. 
    IFTTT ifttt("EventName","Secret Key", &socket); // EventName, Secret Key, socket to use
	
    ifttt.addIngredients("value1","value2","value3");
    ifttt.trigger(IFTTT_POST);
}
