#include "mbed.h"
#include "HTTPClient.h"
#include "ESP8266Interface.h"
#include "TCPSocketConnection.h"
#include "SoftSerialSendOnry.h"

ESP8266Interface wifi(dp16,dp15,dp4,"SSID","Password",115200); // TX,RX,Reset,SSID,Password,Baud

SoftSerialSendOnry pc(dp10);
int main()
{
    HTTPClient http;
    char str[512];

    pc.baud(9600);

    wifi.init(); //Reset
    wifi.connect(); //Use DHCP
    pc.printf("IP Address is %s\n", wifi.getIPAddress());

    //GET
    pc.printf("\nTrying to fetch page using GET...\n\r");
    int ret = http.get("http://jksoft.cocolog-nifty.com/msg.txt", str, 512);//IP address is httpbin.org/get
    
    if (ret == 0) {
        pc.printf("Page fetched successfully - read %d characters\n\r", strlen(str));
        pc.printf("Result: %s\n\r", str);
    } else {
        pc.printf("Error - ret = %d - HTTP return code = %d\n\r", ret, http.getHTTPResponseCode());
    }
}
