/* Sample code for mbed eDISP Library
 * Copyright (c) 2010 todotani
 * Released under the MIT License: http://mbed.org/license/mit
 */

#include "mbed.h"
#include "eDisp.h"
#include "SDFileSystem.h"
#include "wave_player.h"
#include "LEDStrip.h"

#define LED_NUM         16
#define LED_DATA_NUM    3

AnalogIn sensor(p20);
Serial pc(USBTX, USBRX); // tx, rx
SDFileSystem sd(p5, p6, p7, p8, "sd"); //SD card
AnalogOut DACout(p18);
wave_player waver(&DACout);
Serial tempe(p9, p10);  // tx, rx
DigitalOut led1(LED1);
DigitalOut led2(LED2);

unsigned char led_data[LED_NUM][3];

float ss;
int sensor_on_f = 0;


// RGB color code table
int RGB_color[16] = {
    RGB_Navy,
    RGB_Silver,
    RGB_Blue,
    RGB_Maroon,
    RGB_Purple,
    RGB_Red,
    RGB_Fuchsia,
    RGB_Green,
    RGB_Teal,
    RGB_Lime,
    RGB_Aqua,
    RGB_Olive,
    RGB_Gray,
    RGB_Yellow,
    RGB_White,
    RGB_Black };

// RGB color name table
char* colorName[16] = {
    "Navy",
    "Silver",
    "Blue",
    "Maroon",
    "Purple",
    "Red",
    "Fuchsia",
    "Green",
    "Teal",
    "Lime",
    "Aqua",
    "Olive",
    "Gray",
    "Yellow",
    "White",
    "Black" };


const unsigned char _RED[3] =   { 0xFF, 0   , 0    };
const unsigned char _ORENGE[3] =   { 0xFF, 0x8F   , 0    };
const unsigned char _ORENGE1[3] =   { 0xAF, 0x8F   , 0    };
const unsigned char _GEN[3] =   { 0xFF, 0x8F   , 0x8F    };
const unsigned char _GREEN[3] =     { 0   , 0xFF, 0    };
const unsigned char _BLUE[3] =  { 0   , 0   , 0xFF };
const unsigned char _YELLOW[3] = { 0xFF, 0xFF, 0    };
const unsigned char _PURPLE[3] = { 0xFF, 0   , 0xFF };
const unsigned char _AQUA[3] =  { 0   , 0xFF, 0xFF };
const unsigned char _WHITE[3] =     { 0xFF, 0xFF, 0xFF };
const unsigned char _GLAY[3] =  { 0x80, 0x80, 0x80 };
const unsigned char _OFF[3] =   { 0, 0, 0 };

unsigned char _todat[3];

eDisp display(p28, p27, 115200);     // tx, rx, baud
Ticker flipper;
Ticker flipper1;
extern int sound_stop;
int ni_end = 0;

#define MAX_PHOTONO 10

void send_led()
{
    for(int i=0;i<LED_NUM;i++)
    {
        tapeSet(i,led_data[i][0] << 16 | led_data[i][1] << 8 | led_data[i][2]);
    }
    tapeSend();
}

void send_led2()
{
    static int i = 0;

    tapeSet(i,led_data[i][0] << 16 | led_data[i][1] << 8 | led_data[i][2]);
    i++;
    if( i >= LED_NUM )
    {
        i = 0;
        tapeSend();
    }
}


void voice(char* file_path)
{
    FILE *wave_file;
    
    wave_file=fopen(file_path,"r");
    waver.play(wave_file);
    fclose(wave_file);
}

// color 0~100 weather 0:sun 1:ran 2: cloude 
void tempescope( int color , int weather , int lightning )
{
    pc.printf("Zr,%d,%d,%d\n\r",color,weather,lightning);
  //  for(int i = 0 ; i < 10 ; i++ )
  //  {
        tempe.printf("Zr,%d,%d,%d\r\n",color,weather,lightning);
  //      wait(0.1);
  //  }
}

void flip() {
    ss = sensor;
    
    if( ss > 0.2 )
    {
        if( sensor_on_f == 0 )
        {
            waver.set_s_stop();
            led2 = 1;
            sensor_on_f = 1;
        }
    }
    else
    {
        sensor_on_f = 0;
    }
    led1 = !led1;
    //send_led();

}

int near(unsigned char *from_dat,const unsigned char *to_dat,int wide)
{
    int ret_code_l = 1;
    
    for( int i=0;i<LED_DATA_NUM;i++)
    {
        if( from_dat[i] < to_dat[i] )
        {
            if( (from_dat[i]+wide) < to_dat[i] )
            {
                from_dat[i] = from_dat[i] + wide;
                ret_code_l = 0;
            }
            else
            {
                from_dat[i] = to_dat[i];

            }
        }
        else if( from_dat[i] > to_dat[i] )
        {
            if( (from_dat[i]-wide) > to_dat[i])
            {
                from_dat[i] -= wide;
                ret_code_l = 0;
            }
            else
            {
                from_dat[i] = to_dat[i];
            }
        }
    }
    
    return(ret_code_l);
}

void flip2() {
    ni_end = 0;
    
    for(int j=0;j<LED_NUM;j++)
    {
        ni_end += near( led_data[j] , _todat , 10 );
    }
}

void slow_light_all(const unsigned char *base_dat,int speed)
{
    int i,j;
    while(i!=LED_NUM)
    {
        i = 0;
        for(j=0;j<LED_NUM;j++)
        {
            i += near( led_data[j] , base_dat , 5 );
        }
        send_led();
        wait_ms(speed);
    }
}

int main() {
    int i;
    int photo_no = 0;
    int old_photo_no = 1;
    
    wait(2);
    
    //tempescope( 100 , 1 , 0 );
    
    for(int i=0;i<LED_NUM;i++)
    {
        memcpy( &led_data[i][0] , &_WHITE[0] , LED_DATA_NUM );
//        for(int j=0;j<LED_DATA_NUM;j++)
//        {
//           led_data[i][j] = _AQUA;
//        }
    }
    
    tapeInit(0, LED_NUM);
    
//    slow_light_all(_AQUA , 100);
    
    memcpy( _todat , _AQUA , 3);
    
    wait(2);
    
    send_led();
        
    display.pic(0,1);
    wait(1.0);
    display.pic(1,2);
    wait(1.0);
    display.pic(2,3);
    wait(1.0);
    display.pic(3,4);
    wait(1.0);
    flipper1.attach(&flip2, 0.1);
    
while(1)
{
    ss = sensor;
    pc.printf("sensor:%f\r\n",ss);
    
    if( old_photo_no != photo_no )
    {
        display.pic(0,photo_no+1);
        while(ni_end!=LED_NUM)
        {
            send_led();
        }
        flipper1.detach();
        old_photo_no = photo_no;
        display.chg_buff(0);
        flipper.attach(&flip, 0.1);
        switch( photo_no )
        {
        case 0:
            voice("/sd/1.wav");
            break;
        case 1:
            voice("/sd/2.wav");
            break;
        case 2:
            voice("/sd/3.wav");
            break;
        case 3:
            voice("/sd/4.wav");
            break;
        case 4:
            voice("/sd/5.wav");
            break;
        case 5:
            voice("/sd/6.wav");
            break;
        case 6:
            voice("/sd/7.wav");
            break;
        case 7:
            voice("/sd/8.wav");
            break;
        case 8:
            voice("/sd/9.wav");
            break;
        case 9:
            voice("/sd/10.wav");
            break;
        }   

        flipper.detach();
        led2 = 0;
        sensor_on_f = 0;
        flipper1.attach(&flip2, 0.1);
    }
    
    if( ss > 0.2 )
    {
        if( sensor_on_f == 0 )
        {
            photo_no++;
            if( photo_no >= MAX_PHOTONO )
            {
                photo_no = 0;
            }
            switch( photo_no )
            {
            case 0:
                memcpy( _todat , _WHITE , 3);
                tempescope( 23 , 2 , 0 );
                break;
            case 1:
                memcpy( _todat , _ORENGE , 3);
                tempescope( 0 , 2 , 0 );
                break;
            case 2:
                memcpy( _todat , _ORENGE1 , 3);
                tempescope( 100 , 0 , 0 );
                break;
            case 3:
                memcpy( _todat , _BLUE , 3);
                tempescope( 70 , 1 , 0 );
                break;
            case 4:
                memcpy( _todat , _ORENGE , 3);
                tempescope( 50 , 0 , 0 );
                break;
            case 5:
                memcpy( _todat , _GLAY, 3);
                tempescope( 0 , 0 , 0 );
                break;
            case 6:
                memcpy( _todat , _AQUA , 3);
                tempescope( 100 , 0 , 0 );
                break;
            case 7:
                memcpy( _todat , _OFF , 3);
                tempescope( 0 , 1 , 1 );
                break;
            case 8:
                memcpy( _todat , _ORENGE , 3);
                tempescope( 10 , 2 , 0 );
                break;
            case 9:
                memcpy( _todat , _RED , 3);
                tempescope( 100 , 0 , 0 );
                break;
            }   

        }
        sensor_on_f = 1;
    }
    else
    {
        sensor_on_f = 0;
    }
    send_led();
    wait(0.1); 
}

#if 1
    wait(2);
    
    display.pic(0,1);
    wait(1.0);
    display.pic(1,2);
    wait(1.0);
    
    while(1)
    {
        display.chg_buff(0);
        wait(1.0);
        display.chg_buff(1);
        wait(1.0);
    }
    
    while(1);
#endif
    
    while (1) {
        // Test-1
        // clear graphics screen
        display.fillRect(0, 320, 240, 0, 0, RGB_Black); 
        display.reset();
        for (i = 0; i < 15; i++) {
            display.fillRect(0, 320, 16, 0, i*16, RGB_color[i]);
            display.locate(0, i);
            display.printf("%s", colorName[i] );
        }
        wait(2);

        // Test-2
        display.fillRect(0, 320, 240, 0, 0, RGB_Black);
        display.cls();
        for (i = 0; i < 15; i++) {
            display.drawLine(0, 1, i*16+1, 319, i*16+1, RGB_color[i]);
            display.drawLine(0, i*21+1, 0, i*21+1, 239, RGB_color[i]);
        }
        wait(2);

        // Test-3
        for (i = 0; i < 15; i++) {
            display.fillRect(0, 320, 240, 0, 0, RGB_color[i]);
            wait(0.2);      // wait until completion of draw
        }
        wait(2);
        
        // Test-4
        display.fillRect(0, 320, 240, 0, 0, RGB_Black);
        display.cls();
        for (i = 0; i < 15; i++) {
            display.textColor(RED + i%7);
            display.printf("�����\��OK �`A�aB�bC\n");
        }
        wait(2);
    }
}
