/* mbed eDISP Library
 * Copyright (c) 2010 todotani
 * Version 0.1 (March 6, 2010)
 * Released under the MIT License: http://mbed.org/license/mit
 */

#ifndef MBED_EDISP_H
#define MBED_EDISP_H

#include "mbed.h"
#include "Stream.h"

// Text Color code
#define BLACK   30
#define RED     31
#define GREEN   32
#define YELLOW  33
#define BLUE    34
#define PURPLE  35
#define AQUA    36
#define WHITE   37
#define TRANSPARENT 49      // default background color

// RGB555 color code (converted from 32bit color code)
#define RGB_Black   (0      << 10) + (0      << 5) + 0
#define RGB_Navy    (0      << 10) + (0      << 5) + 0x80/8
#define RGB_Silver  (0xc0/8 << 10) + (0xc0/8 << 5) + 0xc0/8
#define RGB_Blue    (0      << 10) + (0      << 5) + 0xff/8
#define RGB_Maroon  (0x80/8 << 10) + (0      << 5) + 0
#define RGB_Purple  (0x80/8 << 10) + (0      << 5) + 0x80/8
#define RGB_Red     (0xff/8 << 10) + (0      << 5) + 0
#define RGB_Fuchsia (0xff/8 << 10) + (0      << 5) + 0xff/8
#define RGB_Green   (0      << 10) + (0x80/8 << 5) + 0
#define RGB_Teal    (0      << 10) + (0x80/8 << 5) + 0x80/8
#define RGB_Lime    (0      << 10) + (0xff/8 << 5) + 0
#define RGB_Aqua    (0      << 10) + (0xff/8 << 5) + 0xff/8
#define RGB_Olive   (0x80/8 << 10) + (0x80/8 << 5) + 0
#define RGB_Gray    (0x80/8 << 10) + (0x80/8 << 5) + 0x80/8
#define RGB_Yellow  (0xff/8 << 10) + (0xff/8 << 5) + 0
#define RGB_White   (0xff/8 << 10) + (0xff/8 << 5) + 0xff/8


namespace mbed {

/* Class: eDisp
 * Driver for eDISP (http://www.ddlab.jp/shop/edisp/syouhin.cgi)
 *
 * Allows you to print to a Text LCD screen, set color and locate/cls. 
 * Also support graphics functions fillRect, drawLine
 *
 */
class eDisp : public Stream {
public:
    /* Constructor: eDisp
     * Create a eDisp object, connected to the specified pins
     *
     * All signals must be connected to pair of Serial Tx/Rx pin
     * (p9/p10, p13/p14 or p28/p27)
     *
     * Variables:
     *  tx - Used to specify tx of Serial port
     *  rx - Used to specify rx of Serial port (acturally not used)
     *  baud - baudrate of serial port
     */
    eDisp(PinName tx, PinName rx, int baud = 19200,
        int columns = 40, int rows = 15);

#if 0 // Inhereted from Stream, for documentation only
    /* Function: putc
     *  Write a character
     *
     * Variables:
     *  c - The character to write to the serial port
     */
    int putc(int c);

    /* Function: printf
     *  Write a formated string
     *
     * Variables:
     *  format - A printf-style format string, followed by the
     *      variables to use in formating the string.
     */
    int printf(const char* format, ...);
#endif

    /* Function: locate
     * set cursor position
     * Variables:
     *   colum - x position (0 - 39)
     *   row   - y position (0 - 14)
     */
    void locate(int column, int row);

    /* Function: textColor
     * Set text color
     * Variables:
     *   color - Text color code
     */
    void textColor(int color);

    /* Function: backgroundColor
     * Set backgound color
     * Variables:
     *   color - Text color code
     */
    void backgroundColor(int color);

    /* Function: cls
     * Clear the screen, and locate to 0,0
     */
    void cls();

    /* Function: reset
     * Set default text/backgroudn color, clear the screen, and locate to 0,0
     */
    void reset();

    /* Function: fillRect
     * Fill secreen with specified color
     * Variables:
     *   buffer - number of screen buffer (0 - 3)
     *   width  - width of rectangle (1 - 320)
     *   hight  - hight of rectangle (1 - 240)
     *   x      - x coordinate (0 - 319) of upper left point
     *   y      - y coordinate (0 - 239) of upper left point
     *   color  - RGB555 color code  0rrrrrgggggbbbbb
     */
    void fillRect(int buffer, int width, int hight, int x, int y, int color );

    /* Function: drawLine
     * draw line from (x0, y0) to (x1, y1)
     * Variables:
     *   buffer - number of screen buffer (0 - 3)
     *   x0     - coordinate x (0 - 319) of start point
     *   y0     - coordinate y (0 - 319) of start point
     *   x1     - coordinate x (0 - 319) of end point
     *   y1     - coordinate y (0 - 319) of end point
     *   color  - RGB555 color code  0rrrrrgggggbbbbb
     */
    void drawLine(int buffer, int x0, int y0, int x1, int y1, int color);
    void pic(int buffer ,int num);
    void chg_buff(int buffer);
protected:
    virtual int _putc(int c);
    virtual int _getc();
    void newline();

    Serial _serial;
    int _baud;
    int _row;
    int _column;
    int _columns;   // Number of max columns
    int _rows;      // Number of max rows
};

#endif
}