#include "mbed.h"
#include "MQTTEthernet.h"
#include "MQTTClient.h"
#include "Milkcocoa.h"
#include "MClient.h"

// The default setting is for the Simple IoT Board(mbed LPC1114FN28)
// Please change to fit the platform
Serial pc(USBTX, USBRX);
DigitalOut red(LED1);
Ticker flipper;

/************************* Your Milkcocoa Setup *********************************/

#define MILKCOCOA_APP_ID      "teaidsirehz"
#define MILKCOCOA_DATASTORE   "LED"

/************* Milkcocoa Setup (you don't need to change this!) ******************/

#define MILKCOCOA_SERVERPORT  1883

/************ Global State (you don't need to change this!) ******************/

const char MQTT_SERVER[]  = MILKCOCOA_APP_ID ".mlkcca.com";
const char MQTT_CLIENTID[] = __TIME__ MILKCOCOA_APP_ID;

extern void onpush(MQTT::MessageData& md);

int duty = 0;
int duty_count = 0;

void flip() {
    if( duty_count > duty )
    {
    	red = 0;
    }
    else
    {
    	red = 1;
    }
    
    duty_count++;
	if( duty_count > 100) duty_count = 0;
}

int main() {
    pc.baud(9600);

    MQTTEthernet *ipstack = new MQTTEthernet();
	MClient *client = new MClient(ipstack);
	Milkcocoa *milkcocoa = new Milkcocoa(client, MQTT_SERVER, MILKCOCOA_SERVERPORT, MILKCOCOA_APP_ID, MQTT_CLIENTID);

    pc.printf("Milkcocoa mbed ver demo\n\r\n\r\n\r");
	
	milkcocoa->connect();
	pc.printf("\n\rEther connected\n\r");
	
	pc.printf("%d\n\r",milkcocoa->on(MILKCOCOA_DATASTORE, "push", onpush));
	
	flipper.attach(&flip, 0.0001);
	
	while(1) {
		milkcocoa->loop();
	}
}

void onpush(MQTT::MessageData& md)
{
    MQTT::Message &message = md.message;
	DataElement de = DataElement((char*)message.payload);
	//pc.printf("onpush:%s\n\r",message.payload);
	//pc.printf("%d\n\r",de.getInt("RED"));
	duty = de.getInt("RED");
}