#include "mbed.h"
#include "MQTTMDM.h"
#include "Milkcocoa.h"
#include "MClient.h"

// The default setting is for the u-blox C027
// Please change to fit the platform
Serial pc(USBTX, USBRX);
DigitalOut myled(LED1);

/************************* Your SIM Card Setup *********************************/
//! Set your secret SIM pin here (e.g. "1234"). Check your SIM manual.
#define SIMPIN      "SIMPIN"
/*! The APN of your network operator SIM, sometimes it is "internet" check your 
    contract with the network operator. You can also try to look-up your settings in 
    google: https://www.google.de/search?q=APN+list */
#define APN         "APN"
//! Set the user name for your APN, or NULL if not needed
#define USERNAME    "UserName"
//! Set the password for your APN, or NULL if not needed
#define PASSWORD    "Password" 

/************************* Your Milkcocoa Setup *********************************/

#define MILKCOCOA_APP_ID      "...YOUR_MILKCOCOA_APP_ID..."
#define MILKCOCOA_DATASTORE   "mbed"

/************* Milkcocoa Setup (you don't need to change this!) ******************/

#define MILKCOCOA_SERVERPORT  1883

/************ Global State (you don't need to change this!) ******************/

const char MQTT_SERVER[]  = MILKCOCOA_APP_ID ".mlkcca.com";
const char MQTT_CLIENTID[] = __TIME__ MILKCOCOA_APP_ID;

extern void onpush(MQTT::MessageData& md);

int main() {
// void setup() {
    pc.baud(9600);
    
    MQTTMDM *ipstack = new MQTTMDM(SIMPIN, APN,USERNAME,PASSWORD);
	MClient *client = new MClient(ipstack);
	Milkcocoa *milkcocoa = new Milkcocoa(client, MQTT_SERVER, MILKCOCOA_SERVERPORT, MILKCOCOA_APP_ID, MQTT_CLIENTID);

    pc.printf("Milkcocoa mbed ver demo\n\r\n\r\n\r");
	
	milkcocoa->connect();
	pc.printf("\n\rEther connected\n\r");
	
	pc.printf("%d\n\r",milkcocoa->on(MILKCOCOA_DATASTORE, "push", onpush));
	
// }
	while(1) {
// void loop() {
		milkcocoa->loop();
		
		DataElement elem = DataElement();
		elem.setValue("v", 1);
		
		milkcocoa->push(MILKCOCOA_DATASTORE, elem);
		wait(7.0);
	}
}

void onpush(MQTT::MessageData& md)
{
    MQTT::Message &message = md.message;
	DataElement de = DataElement((char*)message.payload);
	pc.printf("onpush\n\r");
	pc.printf("%d\n\r",de.getInt("v"));
}