#include "SoftSerialSendOnry.h"

SoftSerialSendOnry::SoftSerialSendOnry(PinName TX, const char* name) {
    tx_en = false;
    if (TX != NC) {
        tx = new DigitalOut(TX);
        tx_en = true;
        tx->write(1);
        tx_bit = -1;
        txticker.attach(this, &SoftSerialSendOnry::tx_handler);
    }
    
    baud(9600);
    format();
}

SoftSerialSendOnry::~SoftSerialSendOnry() {
    if (tx_en)
        delete(tx);
}

void SoftSerialSendOnry::baud(int baudrate) {
    bit_period = 1000000 / baudrate;
}

void SoftSerialSendOnry::format(int bits, Parity parity, int stop_bits) {
    _bits = bits;
    _parity = parity;
    _stop_bits = stop_bits;
    _total_bits = 1 + _bits + _stop_bits + (bool)_parity;
}

int SoftSerialSendOnry::_getc()
{
    return(0);    
}