#include "mbed.h"
#include "Milkcocoa.h"
#include "EthernetInterface.h"

EthernetInterface eth;
RawSerial pc(USBTX,USBRX);
AnalogIn sensor(A1);
InterruptIn motion(D2);
 
int motion_detected = 0;

/************************* Your Milkcocoa Setup *********************************/

#define MILKCOCOA_APP_ID      "...YOUR_MILKCOCOA_APP_ID..."
#define MILKCOCOA_DATASTORE   "sensor"

/************* Milkcocoa Setup (you don't need to change this!) ******************/

#define MILKCOCOA_SERVERPORT  1883

/************ Global State (you don't need to change this!) ******************/
const char MQTT_SERVER[]  = MILKCOCOA_APP_ID ".mlkcca.com";
const char MQTT_CLIENTID[] = __TIME__ MILKCOCOA_APP_ID;

extern void onpush(MQTT::MessageData& md);

void irq_handler(void)
{
    motion_detected = 1;
}

int main() {
    float val;
    int motion_cnt = 0;
    
    pc.baud(9600);
    pc.printf("Milkcocoa mbed os ver demo\n\r\n\r\n\r");
    
    int ret = eth.connect();
    if (ret != 0) {
        printf("\r\nConnection error\r\n");
        return -1;
    }
    pc.printf("\n\rEthernet connected\n\r");
    
    Milkcocoa* milkcocoa = new Milkcocoa(&eth, MQTT_SERVER, MILKCOCOA_SERVERPORT, MILKCOCOA_APP_ID, MQTT_CLIENTID);
    
    milkcocoa->connect();
    
    motion.rise(&irq_handler);

    while(1) {
        DataElement elem = DataElement();
        val = sensor.read();
        
        if(motion_detected == 1) {
            motion_cnt++;
            motion_detected = 0;  
        }
        
        elem.setValue("light", val);
        elem.setValue("motion", motion_cnt);
        

        pc.printf("light = %f  motion = %d\r\n",val,motion_cnt);
        
        milkcocoa->push(MILKCOCOA_DATASTORE, elem);

        milkcocoa->loop();

        Thread::wait(2000); 
    }
}
    