#include "mbed.h"
#include "Milkcocoa.h"
#include "ESP8266Interface.h"

ESP8266Interface wifi(D1,D0);
RawSerial pc(USBTX,USBRX);

/************************* WiFi Access Point *********************************/

#define WLAN_SSID       "...SSID..."
#define WLAN_PASS       "...PASS..."

/************************* Your Milkcocoa Setup *********************************/

#define MILKCOCOA_APP_ID      "...YOUR_MILKCOCOA_APP_ID..."
#define MILKCOCOA_DATASTORE   "mbed_esp8266"

/************* Milkcocoa Setup (you don't need to change this!) ******************/

#define MILKCOCOA_SERVERPORT  1883

/************ Global State (you don't need to change this!) ******************/
const char MQTT_SERVER[]  = MILKCOCOA_APP_ID ".mlkcca.com";
const char MQTT_CLIENTID[] = __TIME__ MILKCOCOA_APP_ID;

extern void onpush(MQTT::MessageData& md);

int main() {
    
    pc.baud(9600);
    pc.printf("Milkcocoa mbed os ver demo\n\r\n\r\n\r");
    pc.printf("Connecting to %s\n\r",WLAN_SSID);
    
    int ret = wifi.connect(WLAN_SSID, WLAN_PASS, NSAPI_SECURITY_WPA_WPA2);
    if (ret != 0) {
        printf("\r\nConnection error\r\n");
        return -1;
    }
    pc.printf("\n\rWiFi connected\n\r");
    
    Milkcocoa* milkcocoa = new Milkcocoa(&wifi, MQTT_SERVER, MILKCOCOA_SERVERPORT, MILKCOCOA_APP_ID, MQTT_CLIENTID);
    
    milkcocoa->connect();
    
    pc.printf("%d\n\r",milkcocoa->on(MILKCOCOA_DATASTORE, "push", onpush));
    
#ifdef __MILKCOCOA_THREAD
    milkcocoa->setLoopCycle(5000);
    milkcocoa->start();
#endif
    while(1) {
        DataElement elem = DataElement();
        elem.setValue("v", 1);
        
        milkcocoa->push(MILKCOCOA_DATASTORE, elem);

#ifndef __MILKCOCOA_THREAD
        milkcocoa->loop();
#endif
        Thread::wait(7000);
        
    }
}

void onpush(MQTT::MessageData& md)
{
    MQTT::Message &message = md.message;
    DataElement de = DataElement((char*)message.payload);
    pc.printf("onpush\n\r");
    pc.printf("%d\n\r",de.getInt("v"));
}