#include "mbed.h"
#include "MQTTESP8266.h"
#include "MQTTClient.h"
#include "SoftSerialSendOnry.h"
#include "Milkcocoa.h"
#include "MClient.h"
#include "DHT.h"


// The default setting is for the Simple IoT Board(mbed LPC1114FN28)
// Please change to fit the platform
SoftSerialSendOnry pc(dp10); // tx
DigitalOut myled(dp18);
DHT sensor(dp13, DHT11);

/************************* WiFi Access Point *********************************/

//#define WLAN_SSID       "...SSID..."
//#define WLAN_PASS       "...PASS..."
#define WLAN_SSID       "wx01-dda3ad"
#define WLAN_PASS       "0db20294cb0d3"

/************************* Your Milkcocoa Setup *********************************/

//#define MILKCOCOA_APP_ID      "...YOUR_MILKCOCOA_APP_ID..."
#define MILKCOCOA_APP_ID      "teaidsirehz"
#define MILKCOCOA_DATASTORE   "esp8266"

/************* Milkcocoa Setup (you don't need to change this!) ******************/

#define MILKCOCOA_SERVERPORT  1883

/************ Global State (you don't need to change this!) ******************/

// Create an ESP8266 WiFiClient class to connect to the MQTT server.
// The default setting is for the Simple IoT Board(mbed LPC1114FN28)
// Please change to fit the platform
MQTTESP8266 ipstack(dp16,dp15,dp26,WLAN_SSID,WLAN_PASS); // TX,RX,Reset,SSID,Password,Baud
MClient client(&ipstack);

const char MQTT_SERVER[]  = MILKCOCOA_APP_ID ".mlkcca.com";
const char MQTT_CLIENTID[] = __TIME__ MILKCOCOA_APP_ID;

Milkcocoa milkcocoa = Milkcocoa(&client, MQTT_SERVER, MILKCOCOA_SERVERPORT, MILKCOCOA_APP_ID, MQTT_CLIENTID);

extern void onpush(MQTT::MessageData& md);

int main() {
// void setup() {
    int error = 0;
    double h = 0.0f, c = 0.0f;
    
    pc.baud(9600);
    pc.printf("Milkcocoa mbed ver demo\n\r\n\r\n\r");
    pc.printf("Connecting to %s\n\r",WLAN_SSID);
    milkcocoa.connect();
    pc.printf("\n\rWiFi connected\n\r");
    
    pc.printf("%d\n\r",milkcocoa.on(MILKCOCOA_DATASTORE, "push", onpush));
    
// }
    while(1) {
// void loop() {
        milkcocoa.loop();
        
        error = sensor.readData();
        if (0 == error) {
            c   = sensor.ReadTemperature(CELCIUS);
            h   = sensor.ReadHumidity();
            
            DataElement elem = DataElement();
            elem.setValue("temp", c);
            elem.setValue("hmt", h);
            milkcocoa.push(MILKCOCOA_DATASTORE, elem);
        }
        
        wait(7.0);
    }
}

void onpush(MQTT::MessageData& md)
{
    MQTT::Message &message = md.message;
    DataElement de = DataElement((char*)message.payload);
    pc.printf("onpush\n\r");
    pc.printf("%d\n\r",de.getInt("v"));
}