#ifndef _MCLIENT_H_
#define _MCLIENT_H_

#include "mbed.h"
#include "MQTTClient.h"
#include "MQTTInterface.h"
class MClient
{
 public:
    typedef void (*messageHandler)(MQTT::MessageData&);

	MClient(MQTTInterface *ipstack) : client(MQTT::Client<MQTTInterface, Countdown>(*ipstack))
	{
		_ipstack = ipstack;
	}
    void setDefaultMessageHandler(messageHandler mh)
    {
        client.setDefaultMessageHandler(mh);
    }
    int connect(char* host,int port)
	{
		return _ipstack->connect(host, port);
	}
    int connect()
	{
		return client.connect();
	}
    int connect(MQTTPacket_connectData& options)
	{
		return client.connect(options);
	}
    int publish(const char* topicName, MQTT::Message& message)
    {
		return client.publish(topicName,message);
	}
    int publish(const char* topicName, void* payload, size_t payloadlen, enum MQTT::QoS qos = MQTT::QOS0, bool retained = false)
	{
		return client.publish(topicName,payload,payloadlen,qos,retained);
	}
    int publish(const char* topicName, void* payload, size_t payloadlen, unsigned short& id, enum MQTT::QoS qos = MQTT::QOS1, bool retained = false)
	{
		return client.publish(topicName,payload,payloadlen,id,qos,retained);
	}
    int subscribe(const char* topicFilter, enum MQTT::QoS qos, messageHandler mh)
	{
		return client.subscribe(topicFilter,qos,mh);
	}
    int unsubscribe(const char* topicFilter)
	{
		return client.unsubscribe(topicFilter);
	}
    int disconnect()
	{
		return client.disconnect();
	}
    int yield(unsigned long timeout_ms = 1000L)
	{
		return client.yield(timeout_ms);
	}
    bool isConnected()
    {
        return client.isConnected();
    }
private:
	MQTT::Client<MQTTInterface, Countdown> client;
  	MQTTInterface *_ipstack;
};

#endif