
#if !defined(MQTTINTERFACE_H)
#define MQTTINTERFACE_H

#include "mbed.h"
#include "MQTTmbed.h"
#include "TCPSocket.h"
#include "MQTTSocket.h"

class MQTTInterface : public MQTTSocket
{
public:    
    MQTTInterface(NetworkInterface* nif)
    {
		_nif = nif;
		open(_nif);
    }
    
    NetworkInterface& getEth()
    {
        return *_nif;
    }
    
    void reconnect()
    {
		_nif->disconnect();
        _nif->connect();
    }
    
private:

    NetworkInterface* _nif;
    
};


#endif
