#if !defined(MQTTSOCKET_H)
#define MQTTSOCKET_H

#include "MQTTmbed.h"
#include "TCPSocket.h"

class MQTTSocket
{
public:
	int open(NetworkInterface* nif)
	{
		return socket.open(nif);
	}
	
    int connect(char* hostname, int port, int timeout=1000)
    {
		socket.set_blocking (false);
		socket.set_timeout(timeout);
		_mutex.lock();
        int ret = (int)socket.connect(hostname, port);
		_mutex.unlock();
		
		return ret;
    }

    int read(unsigned char* buffer, int len, int timeout)
    {
		socket.set_blocking (false);
		socket.set_timeout(timeout);
		_mutex.lock();
        int ret = (int)socket.recv((char*)buffer, len);
		_mutex.unlock();
		
		return ret;
    }
    
    int write(unsigned char* buffer, int len, int timeout)
    {
		socket.set_blocking (false);
		socket.set_timeout(timeout); 
		_mutex.lock();
        int ret = (int)socket.send((char*)buffer, len);
		_mutex.unlock();
		
		return ret;
    }
    
    int disconnect()
    {
		_mutex.lock();
    	int ret = (int)socket.close();
		_mutex.unlock();
		
		return ret;
    }
    
private:
	Mutex _mutex;
    TCPSocket socket;
    
};



#endif
