#include "mbed.h"
#include "Adb.h"
#include <TextLCD.h>
TextLCD lcd(p11, p12, p27, p28, p29, p30);
Connection * connection;

Serial pc(USBTX, USBRX);
PwmOut servo1(p26);
PwmOut servo2(p25);
DigitalIn sw1(p13);
DigitalOut led(LED1);

void adbEventHandler(Connection * connection, adb_eventType event, uint16_t length, uint8_t * data)
{
    if (event == ADB_CONNECTION_RECEIVE)
    {
        printf("[ADB RECV]:%d   %d\r\n",data[0],data[1]);
        float val = ((float)data[0] * 5.5) + 1000.0;
        servo1.pulsewidth_us(val);
        val = ((float)data[1] * 5.5) + 1000.0;
        servo2.pulsewidth_us(val);
    }
}

int main()
{
    int now=0,old;
    unsigned short data = 0;
    
    pc.baud(115200);
    servo1.period_us(20000);
    servo2.period_us(20000);
    sw1.mode(PullUp);
    
    
    // Initialise the ADB subsystem.  
    ADB::init();
    // Open an ADB stream to the phone's shell. Auto-reconnect
    connection = ADB::addConnection("tcp:4567", true, adbEventHandler);
    
    while(1)
    {
    
        ADB::poll();
        
        lcd.locate(0, 0);
        lcd.printf("MicroBridge Test");
        
        old = now;
        now = sw1;
        if((now == 1)&&(old==0))
        {
            printf("down key\r\n");
            connection->write(2, (unsigned char*)&data);
            lcd.locate(0, 1);
            lcd.printf("COUNT = %d",data);

            data++;
        }
        led = sw1;
    }
}
