

/** @file PacketBuffer.h
 * @brief Packet Buffer
 */

#ifndef PacketBuffer_H
#define PacketBuffer_H

#include "mbed.h"

typedef struct
{
    char *buf;
    int size;
} PacketBufInf;

class PacketBuffer {
public:
    /** init Stack class
     * @param num  buffering packet num
     * @param packet_size size of packet(max size)
     */
    PacketBuffer(int num,int packet_size);
    ~PacketBuffer();

    /** put to Packet buffer
     * @param packet packet data
     * @param len packet length
     * @return put length
     */
    int PutPacket(char *packet, int len);

    /** get from ring buffer
     * @param packet packet data
     * @return get length
     */
    int GetPacket(char *packet);

    void clear();
    int available();
    int use();

private:
    PacketBufInf *p_buf;
    int max_num,max_size;
    int addr_w, addr_r;
};
#endif