#include "mbed.h"
#include "mbed.h"
#include "HTTPClient.h"
#include "ESP8266Interface.h"
#include "TCPSocketConnection.h"
#include "SB1602E.h"
#include "BME280.h"
#include "mitb.h"

ESP8266Interface wifi(MITB_WIFI_TX,MITB_WIFI_RX,MITB_WIFI_RST,"ssid","pass",115200); // TX,RX,Reset,SSID,Password,Baud
SB1602E lcd(I2C_SDA,I2C_SCL);         //SDA, SCL
BME280 sensor(I2C_SDA,I2C_SCL);       //SDA, SCL
DigitalOut myled(MITB_LED);
Serial pc(USBTX,USBRX);

int main() {
    HTTPClient http;
    char str[512];
    
    lcd.contrast(0x30);
    
    lcd.printf( 0, "WiFi..");
    
    wifi.init(); //Reset
    wifi.connect(); //Use DHCP
    
    lcd.printf( 1, "OK");
    pc.printf("IP Address is %s\n", wifi.getIPAddress());
    
    wait(2.0);

    //GET
    lcd.printf( 0, "HTTP GET");
    pc.printf("\nTrying to fetch page using GET...\n\r");
    int ret = http.get("http://jksoft.cocolog-nifty.com/msg.txt", str, 512);//IP address is httpbin.org/get
    
    if (ret == 0) {
        lcd.printf( 1, "OK");
        pc.printf("Page fetched successfully - read %d characters\n\r", strlen(str));
        pc.printf("Result: %s\n\r", str);
    } else {
        lcd.printf( 1, "NG");
        pc.printf("Error - ret = %d - HTTP return code = %d\n\r", ret, http.getHTTPResponseCode());
    }
    
    while(1) {
        float temperature = sensor.getTemperature();
        float humidity = sensor.getHumidity();
        float pressure = sensor.getPressure();
        
        pc.printf("%2.2f degC, %04.2f hPa, %2.2f %%\n", temperature, pressure, humidity);
        lcd.clear();
        lcd.printf( 0, "%2.2f",temperature);
        lcd.printf( 1, "%2.2f",humidity);
        myled = !myled;
        wait(1.0);
    }
}
