#include "mbed.h"
#include "TB6612.h"

BusOut leds( LED1 , LED2 );
AnalogIn floor_sensor[] = { (p15) , (p16) , (p17) , (p18) };
TB6612 left(p21,p12,p11);
TB6612 right(p22,p14,p13);
DigitalIn sw(p29);

int Sensor()
{
    int ret = 0;
    if(floor_sensor[1].read_u16() > 10000)
    {
        ret |= 0x01;
    }
    if(floor_sensor[2].read_u16() > 10000)
    {
        ret |= 0x02;
    }
    
    return(ret);
}

int main() {

    sw.mode(PullUp);
    
    while(sw==1)
    {
        leds = Sensor();
    }
    
    while(1) {
        int val = Sensor();
        
        leds = val;
        
        switch(val)
        {
        case 0x01:
            left = 100;
            right = 0;
            break;
        case 0x02:
            right = 100;
            left = 0;
            break;
        case 0x03:
            left = 100;
            right = 100;
            break;
        default:
            left = 0;
            right = 0;
            break;        
        }
   }
}
