#include "mbed.h"
#include "LM75B.h"

//Create an LM75B object at the default address (ADDRESS_0)
LM75B sensor(dp5, dp27);

int main()
{
    //Try to open the LM75B
    if (sensor.open()) {
        printf("Device detected!\n");

        while (1) {
            //Print the current temperature
            printf("Temp = %.3f\n", (float)sensor);

            //Sleep for 0.5 seconds
            wait(0.5);
        }
    } else {
        error("Device not detected!\n");
    }
}
