#include "mbed.h"
#include "wave_player.h"
#include "SDFileSystem.h"

DigitalOut myled(LED1);
AnalogOut DACout(p18);
DigitalOut AMPEnable(p12);
DigitalIn SW1(p25);

wave_player waver(&DACout,&AMPEnable);
SDFileSystem sd(p5, p6, p7, p8, "sd");  //SD card

Ticker flipper;


void flip() {
    static int old_sw = 1;
    if((SW1 == 0)&&(old_sw == 1))
    {
        waver.set_s_stop();
    }
    old_sw = SW1;
}

void player(char* file_path)
{
    FILE *wave_file;
    
    wave_file=fopen(file_path,"r");
    waver.play(wave_file);
    fclose(wave_file);
}

int main() {
    SW1.mode(PullUp);
    flipper.attach(&flip, 0.1);
    
    player("/sd/1.wav");
    wait(0.5);

    while(1) {
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);
    }
}
