#include "mbed.h"

AnalogOut DACout(p18);
DigitalOut AMPEnable(p12);
DigitalIn SW1(p25);
DigitalIn SW2(p26);

void wave(float volume , float fq , float time)
{
    float w_time = 1.0 / fq;

    AMPEnable = 0;
    for (float i=0; i<time / w_time; i++) {
        DACout = volume;
        wait(w_time/2);
        DACout = 0.0;
        wait(w_time/2);
    }
    AMPEnable = 1;
    
}

int main() {
    SW1.mode(PullUp);
    SW2.mode(PullUp);

    while(1)
    {
        if( SW1 == 0 )
        {
            for( int i = 0 ; i < 10 ; i++ )
            {
                wave( 0.2 , i * 500.0 , 0.2 );
            }
        }
        if( SW2 == 0 )
        {
            wave( 0.2 , 2000.0 , 0.2 );
            wave( 0.2 , 1000.0 , 0.2 );
        }
    }
}
