#ifndef USB_MJPEG_H
#define USB_MJPEG_H
#include "UsbInc.h"

class usb_stream {
public:
    virtual void input(uint16_t frame, uint8_t* buf, int len) = 0;
};

class usb_mjpeg : public usb_stream {
public:
    usb_mjpeg(uint8_t* buf = NULL, int size = 4800);
    ~usb_mjpeg();
    virtual void input(uint16_t frame, uint8_t* buf, int len);
    int status();
    uint16_t ReportErrorFID;
    uint16_t ReportErrorPTS;
private:
    void _open();
    void _wrtie(uint8_t* buf, int len);
    void _close();

    uint8_t* m_buf;
    int m_pos;
    bool check_SOI(uint8_t* buf, int len);
    bool check_EOI(uint8_t* buf, int len);
    void analyticsJPEG(uint8_t* buf, int len);
    int m_seq;
    int m_size;
    uint8_t m_bfh;
    uint32_t m_pts; 
};
#endif //USB_MJPEG_H