#ifndef _MYDBG_H_
#define _MYDBG_H_

#ifdef __DEBUG
#include "Utils.h"
#define DBG(...) do{fprintf(stderr,"[%s@%d] ",__PRETTY_FUNCTION__,__LINE__);fprintf(stderr,__VA_ARGS__);} while(0);
#define DBG2(...) do{fprintf(stderr,"[%d] ",__LINE__);fprintf(stderr,__VA_ARGS__);} while(0);
#define DBG_BYTES(A,B,C) do{printf("[%s@%d] ",__PRETTY_FUNCTION__,__LINE__);printfBytes(A,B,C);}while(0);
#define DBG_HEX(A,B) do{printf("[%s@%d]\n",__PRETTY_FUNCTION__,__LINE__);printHex(A,B);}while(0);
#define DBG_LED4(A) led4.write(A)
#define DBG_PRINTF(...) do{fprintf(stderr,__VA_ARGS__);} while(0);
#else //__DEBUG
#define DBG(...)  while(0);
#define DBG2(...)  while(0);
#define DBG_BYTES(A,B,C) while(0);
#define DBG_HEX(A,B)  while(0);
#define DBG_LED4(A) while(0);
#define DBG_PRINTF(...)  while(0);
#endif //__DEBUG

#ifdef __DEBUG3
#define DBG3(...) do{fprintf(stderr,"[%s@%d] ",__PRETTY_FUNCTION__,__LINE__);fprintf(stderr,__VA_ARGS__);} while(0);
#else //__DEBUG3
#define DBG3(...)  while(0);
#endif //__DEBUG3

#ifndef __NODEBUG
#define DBG_ASSERT(A) while(!(A)){fprintf(stderr,"\n\n%s@%d %s ASSERT!\n\n",__PRETTY_FUNCTION__,__LINE__,#A);exit(1);};
#else
#define DBG_ASSERT(A)  while(0);
#endif

#define VERBOSE(...) do{printf(__VA_ARGS__);} while(0);

#endif //_MYDBG_H_
