#include "mbed.h"
#include "ESP8266Interface.h"
#include "TCPSocketConnection.h"
#include "ifttt.h"
#include "SoftSerialSendOnry.h"

AnalogIn thermistor(dp13);   /* Temperature sensor connected to Analog Grove connector */

ESP8266Interface wifi(dp16,dp15,dp4,"SSID","Password",115200); // TX,RX,Reset,SSID,Password,Baud

SoftSerialSendOnry pc(dp10); // tx

float getTemperature()
{
    unsigned int a, beta = 3975;
    float temperature, resistance;

    a = thermistor.read_u16(); /* Read analog value */
    
    /* Calculate the resistance of the thermistor from analog votage read. */
    resistance= (float) 10000.0 * ((65536.0 / a) - 1.0);
    
    /* Convert the resistance to temperature using Steinhart's Hart equation */
    temperature=(1/((log(resistance/10000.0)/beta) + (1.0/298.15)))-273.15; 

	return(temperature);	
}

int main()
{
    pc.baud(9600);
    wifi.init(); //Reset
    wifi.connect(); //Use DHCP
    pc.printf("IP Address is %s \n\r", wifi.getIPAddress());
    TCPSocketConnection socket;
    
    // Initialize ifttt object, add up to 3 optional values, trigger event. 
    IFTTT ifttt("EventName","Secret Key", &socket); // EventName, Secret Key, socket to use

	char tmp[64];
	
	sprintf(tmp,"%f",getTemperature());

    ifttt.addIngredients(tmp,"value2","value3");
    ifttt.trigger(IFTTT_POST);
}
