#include "mbed.h"
#include "EthernetInterface.h"
#include "TCPSocketConnection.h"
#include "ifttt.h"

EthernetInterface eth;
RawSerial pc(USBTX, USBRX); // tx, rx
AnalogIn ain(p15);

int main()
{
    pc.baud(9600);
    eth.init(); //Use DHCP
    eth.connect();
    printf("IP Address is %s \n\r", eth.getIPAddress());
    TCPSocketConnection socket;

    // Initialize ifttt object, add up to 3 optional values, trigger event.
    IFTTT ifttt("YourEventName","ChangeToYourSecretKey", &socket); // EventName, Secret Key, socket to use
    
    float tmp;
    char msg[10];
    
    tmp = (ain - 0.1818)/0.00303;
    
    sprintf(msg,"%f",tmp);
    
    printf("msg:%s\r\n",msg);

    // Send Data using POST
    ifttt.addIngredients(msg,"","");
    ifttt.trigger(IFTTT_POST);

    eth.disconnect();
    while(1) {
    }
}
