#include "mbed.h"
#include "ESP8266Interface.h"
#include "TCPSocketConnection.h"
#include "ifttt.h"
#include "SoftSerialSendOnry.h"
#include "DHT.h"

DHT sensor(dp13, DHT11);

ESP8266Interface wifi(dp16,dp15,dp4,"SSID","Password",115200); // TX,RX,Reset,SSID,Password,Baud

SoftSerialSendOnry pc(dp10); // tx

int main()
{
    int error = 0;
    float h = 0.0f, c = 0.0f;

    pc.baud(9600);
    wifi.init(); //Reset
    wifi.connect(); //Use DHCP
    pc.printf("IP Address is %s \n\r", wifi.getIPAddress());
    TCPSocketConnection socket;
    
    error = sensor.readData();
    if (0 == error) {

        c   = sensor.ReadTemperature(CELCIUS);
        h   = sensor.ReadHumidity();

        // Initialize ifttt object, add up to 3 optional values, trigger event. 
        IFTTT ifttt("EventName","Secret Key", &socket); // EventName, Secret Key, socket to use
    
        char tmp1[16],tmp2[16];
        
        sprintf(tmp1,"%4.2f",c);
        sprintf(tmp2,"%4.2f",h);
    
        ifttt.addIngredients(tmp1,tmp2,"value3");
        ifttt.trigger(IFTTT_POST);

    } else {
        pc.printf("Error: %d\n", error);
    }
}
