/* mbed Microcontroller Library
 * Copyright (c) 2006-2013 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#ifndef IFTTT_H
#define IFTTT_H

#include "mbed.h"
#include "TCPSocketConnection.h"

#define IFTTT_FAIL -1
#define IFTTT_SUCCESS 0

#define IFTTT_MAX_RETRY 5
#define IFTTT_MAX_SIZE_SECRETKEY 50
#define IFTTT_MAX_SIZE_EVENTNAME 50
#define IFTTT_MAX_SIZE_STRING 512

#define IFTTT_IP "maker.ifttt.com"
#define IFTTT_PORT 80

#define IFTTT_GET 0
#define IFTTT_POST 1


/**
* The IFTTT class (if this then that)
*/
class IFTTT
{

public:

    /**
    * Constructor, initialize the Event Name and Secret Key to be used
    *
    * @param event event name of trigger
    * @param key secret key provided by the maker channel for your event
    */
    IFTTT(const char * event, const char * key, TCPSocketConnection * s = NULL);

    /**
    * Add ingredients (values) to be sent to maker.ifttt.com
    *
    * @param v1 value 1 to send
    * @param v2 value 2 to send
    * @param v3 value 3 to send
    *
    * @return true if successful, false if failed
    */
    bool addIngredients(char * v1 = NULL, char * v2 = NULL, char * v3 = NULL);

    /**
    * Add ingredients (values) to be sent to maker.ifttt.com
    *
    * @param v1 value 1 to send
    * @param v2 value 2 to send
    * @param v3 value 3 to send
    *
    * @return true if successful, false if failed
    */
    bool addIngredients(int v1 = NULL, int v2 = NULL, int v3 = NULL);

    /**
    * Send data via POST or GET to maker.ifttt.com
    *
    * @param iftttType specifies how to send the data. POST by default, GET optional.
    *
    * @return true if successful, false if failed
    */
    bool trigger(int triggerType = IFTTT_POST);

private:

    /**
    * Send data to maker.ifttt.com via GET Query parameters
    *
    * @param name explanation
    *
    * @return true if successful, false if failed
    */
    bool get();

    /**
    * Send data to maker.ifttt.com via POST payload, encoded as JSON
    *
    * @param name explanation
    *
    * @return true if successful, false if failed
    */
    bool post();

    TCPSocketConnection * socket;
    char eventName[IFTTT_MAX_SIZE_EVENTNAME];
    char secretKey[IFTTT_MAX_SIZE_SECRETKEY];
    const char * v1;
    const char * v2;
    const char * v3;
    const char * host;
    int port;

};

#endif // IFTTT_H
