#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPClient.h"
#include "TextLCD.h"

EthernetNetIf eth;
HTTPClient http;
TextLCD lcd(p11, p12, p27, p28, p29, p30); // rs, e, d4-d7
  
int main() {

  lcd.cls();
  lcd.locate(0, 0);
  lcd.printf("Ether connect..");
  printf("Setting up...\n");
  
  EthernetErr ethErr = eth.setup();
  if(ethErr)
  {
    lcd.locate(0, 1);
    lcd.printf("ERROR");
    printf("Error %d in setup.\n", ethErr);
    return -1;
  }
  lcd.locate(0, 1);
  lcd.printf("OK");
  printf("Setup OK\n");
  
  HTTPText txt;
  
  HTTPResult r = http.get("http://jksoft.cocolog-nifty.com/msg.txt", &txt);
  if(r==HTTP_OK)
  {
    lcd.cls();
    lcd.locate(0, 0);
    lcd.printf("%s",txt.gets());
    
    printf("Result :\"%s\"\n", txt.gets()); 
  }
  else
  {
    lcd.cls();
    lcd.locate(0, 0);
    lcd.printf("HTTP GET ERR");
    
    printf("Error %d\n", r);
  }
  
  while(1)
  {
    
  }
}
