// GPS Logger mbed LPC11U24

#include "mbed.h"
#include "SDFileSystem.h"

SDFileSystem sd(p5, p6, p7, p8, "fs");

Serial gps(p9, p10);
Serial pc(USBTX, USBRX);

InterruptIn pps(p14);

DigitalOut pps_stat(LED1);
DigitalOut sd_access(LED2);
DigitalOut rx_status(LED3);
DigitalIn enable(p22);

int num = 0;
int pps_count = 0;

// GPS 1pps interrupt
void int_pps() {
    pps_stat =! pps_stat;
    pps_count += 1;
}


int main() {
    
    char tmp;
    char data[80];
    int log_count = 0;
    bool rec_flag = false;
    int before_sw = 1;
    FILE *fp = NULL;
    
    enable.mode(PullUp);

    pps_stat = 0;
    sd_access = 0;
    rx_status = 0;

    pps.rise(&int_pps); 
    gps.baud(115200);
    
    
    sd_access = 1;

    while (1) {
        int sw = enable;
        
        if( (sw == 0) && (before_sw == 1) )
        {
            if( rec_flag )
            {
                rec_flag = false;
                fclose(fp);
                fp = NULL;
            }
            else
            {
                rec_flag = true;
                fp = fopen("/fs/gps.log", "w");
            }
            wait(0.2);
        }
        before_sw = sw;

        if(gps.readable()) {
            tmp = gps.getc();
            data[num] = tmp;
            if( data[num] == '$' ) {
                data[0] = '$';
                num = 1;
            }
            else if( data[num-1] == '\r' && data[num] == '\n' ) {
            
                if(rec_flag)    rx_status = !rx_status;

                data[num+1] = '\0';

                if(memcmp(data, "$GPRMC",6) == 0) {
                                
                    if(pps_count >= 5) {
                        pps_count = 0;
                    
                        if( fp != NULL ) {
                            sd_access =! sd_access;
                            fprintf(fp,"%s",data);
                        }

                    }
                    if(rec_flag)    deepsleep();
                }
                data[0] = '\0';
                num = 0;
            }
            else {
                num++;
                if(num > 80)
                {
                    num = 0;
                }
            }
        }
    }
}   
