/* JKsoft Wallbot BLE Library
 *
 * wallbotble.cpp
 *
 * Copyright (c) 2010-2014 jksoft
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "mbed.h"
#include "wallbotble.h"


wallbotble::wallbotble() :  	_right(P0_28,P0_30,P0_0) , _left(P0_29,P0_23,P0_24) ,
										_sw(P0_16,P0_17),
										_outlow(P0_20),_statusled(P0_18,P0_19),
										_f_sensor1(P0_2),_f_sensor2(P0_3),_f_sensor3(P0_4),_f_sensor4(P0_5)  {
	_right = 0.0;
    _left = 0.0;
    _outlow = 0;	
	_statusled = 0x3;
	_sensor_gain = SENSOR_VAL_GAIN_DEFAULT;
	_sw.mode(PullUp);
}

void wallbotble::left_motor (float speed) {
    _left = speed;
}

void wallbotble::right_motor (float speed) {
    _right = speed;
}

void wallbotble::forward (float speed) {
    _left = speed;
	_right = speed;
}

void wallbotble::backward (float speed) {
    _left = -speed;
	_right = -speed;
}

void wallbotble::left_turn (float speed) {
    _left = -speed;
	_right = speed;
}

void wallbotble::right_turn (float speed) {
    _left = speed;
	_right = -speed;
}

void wallbotble::stop (void) {
    _right = 0.0;
    _left = 0.0;
}

void wallbotble::set_led(int bit) {
	bit |= bit >> 2;
	_statusled = (bit ^ 0x03) & 0x03;
}

void wallbotble::set_led1(int bit) {
	if( bit )
	{
		bit = _statusled ^ 0x03;
		bit = bit | 0x1;
	}
	else
	{
		bit = _statusled ^ 0x03;
		bit = bit & 0x2;
	}
	set_led(bit);
}

void wallbotble::set_led2(int bit) {
	if( bit )
	{
		bit = _statusled ^ 0x03;
		bit = bit | 0x2;
	}
	else
	{
		bit = _statusled ^ 0x03;
		bit = bit & 0x1;
	}
	set_led(bit);
}

void wallbotble::set_f_sensor_gain(int gain) {
	_sensor_gain = gain;
}

void wallbotble::f_sensor_calibrate(void) {

	for(int i = 0 ; i < 4 ; i++)
	{
		_sensor_def[i] = 0;
	}

	for(int j = 0 ; j < 12 ; j++)
	{
		int in[4] = { _f_sensor1.read_u16(),
					 _f_sensor2.read_u16(),
					 _f_sensor3.read_u16(),
					 _f_sensor4.read_u16()
				   };
		set_led(1<<(j%2));
		for(int i = 0 ; i < 4 ; i++)
		{
			_sensor_def[i] += in[i];
		}
		wait_ms(200);
	}
	for(int i = 0 ; i < 4 ; i++)
	{
		_sensor_def[i] /= 12;
	}
	set_led(0);
}

int wallbotble::GetLinePosition(void) {
	int in[4] = { _f_sensor1.read_u16(),
				 _f_sensor2.read_u16(),
				 _f_sensor3.read_u16(),
				 _f_sensor4.read_u16()
			   };
	int stat = 0;
	
	// printf("ad[0]:%05d ad[1]:%05d ad[2]:%05d ad[3]:%05d \n\r",in[0],in[1],in[2],in[3]);
	
	for(int i = 0 ; i < 4 ; i++)
	{		
		if( (in[i] > (_sensor_def[i] + _sensor_gain))
		  ||(in[i] < (_sensor_def[i] - _sensor_gain)) )
		{
			stat |= 1 << i;
		}
	}
    
    return(stat);
}


int wallbotble::GetSw(void) {
	return(_sw ^ 0x3);
}


