/* JKsoft Wallbot BLE Library
 *
 * wallbotble.h
 *
 * Copyright (c) 2010-2014 jksoft
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#ifndef WALLBOT_BLE_H
#define WALLBOT_BLE_H

#include "mbed.h"
#include "TB6612.h"

#define SENSOR_VAL_GAIN_DEFAULT	300

/** wallbot ble control class
 *
 * Example:
 * @code
 * // Drive the wwallbot forward, turn left, back, turn right, at half speed for half a second

#include "mbed.h"
#include "wallbotble.h"

wallbotble wb;
 
int main() {

    wb.sensor_calibrate();

    while(!wb.GetSw())
    {
        wb.set_led(wb.GetLinePosition());
    }
    
    wb.forward(1.0);
    wait (1.0);
    wb.left(1.0);
    wait (1.0);
    wb.backward(1.0);
    wait (1.0);
    wb.right(1.0);
    wait (1.0);
    
    wb.stop();

    while(1);

 }

 * @endcode
 */
class wallbotble  {

    // Public functions
public:

    /** Create the wallbot object connected to the default pins
     */
    wallbotble();
    
    /** Set Sensor gain.
     *
     * @param Sensor gain.
     */
	void set_f_sensor_gain(int gain);
    /** Sensor calibrate
     *
     */
    void f_sensor_calibrate (void);

    /** Directly control the speed and direction of the left motor
     *
     * @param speed A normalised number -1.0 - 1.0 represents the full range.
     */
    void left_motor (float speed);

    /** Directly control the speed and direction of the right motor
     *
     * @param speed A normalised number -1.0 - 1.0 represents the full range.
     */
    void right_motor (float speed);

    /** Drive both motors forward as the same speed
     *
     * @param speed A normalised number 0 - 1.0 represents the full range.
     */
    void forward (float speed);

    /** Drive both motors backward as the same speed
     *
     * @param speed A normalised number 0 - 1.0 represents the full range.
     */
    void backward (float speed);

    /** Drive left motor backwards and right motor forwards at the same speed to turn on the spot
     *
     * @param speed A normalised number 0 - 1.0 represents the full range.
     */
    void left_turn (float speed);

    /** Drive left motor forward and right motor backwards at the same speed to turn on the spot
     * @param speed A normalised number 0 - 1.0 represents the full range.
     */
    void right_turn (float speed);

    /** Stop both motors
     *
     */
    void stop (void);
	
    /** Get floorline position.(int value return.)
     *
     */	
	int GetLinePosition(void);
	
    /** Get switch .(switch OFF:0 or ON:1 return.)
     *
     */	
	int GetSw(void);
	
    /** Set status led .
     * @param led (bit0:LEFT bit2:RIGHT)
     */	
	void set_led(int bit);

    /** Set led1 .
     * @param led (0:off,1:on)
     */	
	void set_led1(int bit);

    /** Set led2 .
     * @param led (0:off,1:on)
     */	
	void set_led2(int bit);
	
	private :

	TB6612 _right;
	TB6612 _left;
	BusIn _sw;
	DigitalOut _outlow;
	BusOut _statusled;
	AnalogIn _f_sensor1;
	AnalogIn _f_sensor2;
	AnalogIn _f_sensor3;
	AnalogIn _f_sensor4;
	int _sensor_gain;
	int _sensor_def[4];  
};

#endif