/**
 * Motor Driver BD6211F Control Library
 *
 * -- BD6211F is a device of the rohm. 
 *
 * Copyright (C) 2011 Junichi Katsu (JKSOFT) 
 */


#include "BD6211F.h"

// BD6211F Class Constructor
BD6211F::BD6211F(PinName fwd, PinName rev):
        _fwd(fwd), _rev(rev) {

    _fwd.period(0.00005);
    _rev.period(0.00005);
    _fwd = 0.0;
    _rev = 0.0;
    bspeed = 0.0;
    timer_flag = false;
}

// Speed Control
//  arg
//   float speed&#65533;F-1.0 &#65533;` 0.0 &#65533;` 1.0
void BD6211F::speed(float speed) {
    
    if( timer_flag == true )    return;
    
    bspeed = speed;
    
    if( speed > 0.0 )
    {
        _fwd = speed;
        _rev = 0.0;
    }
    else if( speed < 0.0 )
    {
        _fwd = 0.0;
        _rev = -speed;
    }
    else
    {
        _fwd = 1.0;
        _rev = 1.0;
    }
}


// Speed Control with time-out
//  arg
//   float sspeed:-1.0 &#65533;` 0.0 &#65533;` 1.0
//   float time  :0.0&#65533;`
void BD6211F::move(float sspeed , float time)
{
    speed(sspeed);
    timer_flag = true;
    timer.attach(this,&BD6211F::timeout,time);
}


void BD6211F::timeout()
{
    timer_flag = false;
    speed(bspeed);
}

