#include "mbed.h"
#include "SoftSerialSendOnry.h"

AnalogIn thermistor(dp13);   /* Temperature sensor connected to Analog Grove connector */

SoftSerialSendOnry pc(dp10); // tx

int main()
{
    unsigned int a, beta = 3975, units, tens;
    float temperature, resistance;

    while(1) {
        a = thermistor.read_u16(); /* Read analog value */
        
        /* Calculate the resistance of the thermistor from analog votage read. */
        resistance= (float) 10000.0 * ((65536.0 / a) - 1.0);
        
        /* Convert the resistance to temperature using Steinhart's Hart equation */
        temperature=(1/((log(resistance/10000.0)/beta) + (1.0/298.15)))-273.15; 
        
        pc.printf("temp=%f\r\n",temperature);
      
        wait(0.5);
    }
}

