// SyRen 25 motor driver
// Simplified Serial Mode
#include "mbed.h"
#include <ros.h>
#include <std_msgs/Int32.h>
//#include <std_msgs/Int32MultiArray.h>  // <- Int32MultiArray makes rosserial not work

#define M_2PI (2*3.14)

//#define SERIAL_COM_MODE  // uncomment for ROS

// serial
Serial out_syren(p9, p10);
#if defined(SERIAL_COM_MODE)
Serial pc(USBTX, USBRX);
#endif  // SERIAL_COM_MODE

// slave select
DigitalOut slave_select_0(p21);
DigitalOut slave_select_1(p22);

// global variables
int motor_ch = 0;  // 0 or 1
int motor_command[2] = { 0, 0 };  // -127 ~ 128

// send motor command
void send_motor_command(int ch, int command) {
    if (ch == 0) {
        slave_select_0 = 1;
    }
    else if (ch == 1) {
        slave_select_1 = 1;
    }
    out_syren.putc(command + 127);
    wait_us(5);
    slave_select_0 = 0;
    slave_select_1 = 0;
}

// init motor drivers
void init_motor_drivers() {
    send_motor_command(0, 0);
    send_motor_command(1, 0);
}

// limit motor command
int limit_motor_command(int command) {
    if (command > 128) return 128;
    if (command < -127) return -127;
    return command;
}

// ROS -------------------------------------------------------------------------
#if !defined(SERIAL_COM_MODE)
ros::NodeHandle nh;

// current motor command publisher
//std_msgs::Int32MultiArray motor_command_current_msgs;  // <- Int32MultiArray makes rosserial not work
//ros::Publisher motor_command_current_pub("motor_command_current", &motor_command_current_msgs);
std_msgs::Int32 motor_command_ch0_current_msgs;
ros::Publisher motor_command_ch0_current_pub("motor_command_ch0_current", &motor_command_ch0_current_msgs);

// motor command subscriber
void message_motor_command_ch0(const std_msgs::Int32& _motor_command) {
    motor_command[0] = _motor_command.data;
}
ros::Subscriber<std_msgs::Int32> motor_command_ch0_sub("motor_command_ch0", &message_motor_command_ch0);
#endif  // SERIAL_COM_MODE
//------------------------------------------------------------------------------

int main() {
    // initialize serials
//    out_syren.baud(9600);  // doesn't work on ROS
    out_syren.baud(38400);
#if defined(SERIAL_COM_MODE)
    pc.baud(9600);
#else
//    nh.getHardware()->setBaud(9600);  // default: 57600
#endif  // SERIAL_COM_MODE

    // initialize motor drivers and ROS
    init_motor_drivers();
#if defined(SERIAL_COM_MODE)
    pc.printf("initialized motor drivers\n");    
#else
    nh.initNode();
    nh.advertise(motor_command_ch0_current_pub);
    nh.subscribe(motor_command_ch0_sub);
#endif  // SERIAL_COM_MODE

    while (1) {
#if defined(SERIAL_COM_MODE)
        switch (pc.getc()) {
            case 's':
                motor_command[0] = 0;
                break;
            case 'a':
                motor_command[0] += 10;
                break;
            case 'd':
                motor_command[0] -= 10;
                break;
            default:
                ;
        }
        send_motor_command(0, limit_motor_command(motor_command[0]));

        pc.printf("%d, %d, %d\n", motor_ch, motor_command[0], motor_command[1]);
#else
        send_motor_command(0, limit_motor_command(motor_command[0]));

//        motor_command_current_msgs.data[0] = motor_command[0];  // <- Int32MultiArray makes rosserial not work
//        motor_command_current_msgs.data[1] = motor_command[1];
//        motor_command_current_pub.publish(&motor_command_current_msgs);
        motor_command_ch0_current_msgs.data = motor_command[0];
        motor_command_ch0_current_pub.publish(&motor_command_ch0_current_msgs);
        
        nh.spinOnce();
        wait_ms(10);
#endif  // SERIAL_COM_MODE
    }
}
