#include "mbed.h"
#include "VL53L0X.h"

#define range1_addr (0x56)
#define range2_addr (0x60)
#define range1_XSHUT   D7
#define range2_XSHUT   D8
#define VL53L0_I2C_SDA   D14 
#define VL53L0_I2C_SCL   D15  
 
Serial pc(SERIAL_TX, SERIAL_RX);
static DevI2C devI2c(VL53L0_I2C_SDA,VL53L0_I2C_SCL); 
 
int main()
{   
    /*Contruct the sensors*/ 
    static DigitalOut shutdown1_pin(range1_XSHUT);
    static VL53L0X range1(&devI2c, &shutdown1_pin, NC);
    static DigitalOut shutdown2_pin(range2_XSHUT);
    static VL53L0X range2(&devI2c, &shutdown2_pin, NC);
    /*Initial all sensors*/   
    range1.init_sensor(range1_addr);
    range2.init_sensor(range2_addr);

    /*Get datas*/
    uint32_t distance1;
    uint32_t distance2;
    int status1;
    int status2;
    while(1){
        status1 = range1.get_distance(&distance1);
        if (status1 == VL53L0X_ERROR_NONE) {
            printf("Range1 [mm]:            %6ld\r\n", distance1);
        } else {
            printf("Range1 [mm]:                --\r\n");
        }

        status2 = range2.get_distance(&distance2);
        if (status2 == VL53L0X_ERROR_NONE) {
            printf("Range2 [mm]:            %6ld\r\n", distance2);
        } else {
            printf("Range2 [mm]:                --\r\n");
        }
        wait(0.5);                 
    }
 
}
 
