/**********************
Jae Kyung Han
ECE 4180 Lab 4
Morse Code Generator
**********************/

#include "mbed.h"
#include "uLCD_4DGL.h"
#include "Speaker.h"
#include "PinDetect.h"
#include "EncodeMorse.cpp"
#include <string>

// USB Serial
Serial pc(USBTX, USBRX);

// uLCD
uLCD_4DGL uLCD(p28,p27,p29); // serial tx, serial rx, reset pin.

// Speaker PWM
Speaker mySpeaker(p26); // Parameter must be a PwmOut pin.

// Pushbuttons
PinDetect pb1(p19);
PinDetect pb2(p20);
PinDetect pb3(p21);
PinDetect pb4(p22);
PinDetect pb5(p23);
PinDetect pb6(p24);

// mbed LEDs
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

// Global Variables
static const char space[] = "000";  // Internationally defined spacing length between Morse code letters is 3. Do not change.
float SpeakerFreq = 1000;
float SpeakerVol = 0.01;
float DotLength = 0.1;          // Duration of a dot.
float Speed = 1.2/DotLength;    // Words per minute (1 word = 50 dots).

void pb1_hit_callback(void)
{
    if(SpeakerFreq < 1960)
    SpeakerFreq = SpeakerFreq + 50;
    
    uLCD.color(DGREY);
    uLCD.locate(0,2); uLCD.printf("Pitch: ");
    uLCD.color(WHITE);
    uLCD.locate(8,2); uLCD.printf("%4.0f Hz",SpeakerFreq);
}
void pb2_hit_callback(void)
{
    if(SpeakerFreq > 100)
        SpeakerFreq = SpeakerFreq - 50;
    else
        SpeakerFreq = 100;
    
    uLCD.color(DGREY);
    uLCD.locate(0,2); uLCD.printf("Pitch: ");
    uLCD.color(WHITE);
    uLCD.locate(8,2); uLCD.printf("%4.0f Hz",SpeakerFreq);
}
void pb3_hit_callback(void)
{
    if(Speed < 100)
        Speed = Speed + 1;
    
    uLCD.color(DGREY);
    uLCD.locate(0,4); uLCD.printf("Speed: ");
    uLCD.color(WHITE);
    uLCD.locate(10,4); uLCD.printf("%2.0f wpm",Speed);
}
void pb4_hit_callback(void)
{
    if(Speed > 1)
        Speed = Speed - 1;
    else
        Speed = 1;
    
    uLCD.color(DGREY);
    uLCD.locate(0,4); uLCD.printf("Speed: ");
    uLCD.color(WHITE);
    uLCD.locate(10,4); uLCD.printf("%2.0f wpm",Speed);
}
void pb5_hit_callback(void)
{
    if(SpeakerVol < 0.045)
        SpeakerVol = SpeakerVol + 0.005;
    
    uLCD.color(DGREY);
    uLCD.locate(0,6); uLCD.printf("Volume: ");
    uLCD.color(WHITE);
    uLCD.locate(10,6); uLCD.printf("%2.0f",SpeakerVol*1000);
}
void pb6_hit_callback(void)
{
    if(SpeakerVol > 0.005)
        SpeakerVol = SpeakerVol - 0.005;
    else
        SpeakerVol = 0;
    
    uLCD.color(DGREY);
    uLCD.locate(0,6); uLCD.printf("Volume: ");
    uLCD.color(WHITE);
    uLCD.locate(10,6); uLCD.printf("%2.0f",SpeakerVol*1000);
}

void UpdateLCD()
{
    uLCD.cls();
    uLCD.color(DGREY);
    uLCD.locate(4,0); uLCD.printf("Morse Code");
    uLCD.locate(0,2); uLCD.printf("Pitch: ");
    uLCD.locate(0,4); uLCD.printf("Speed: ");
    uLCD.locate(0,6); uLCD.printf("Volume: ");
    uLCD.locate(0,8); uLCD.printf("Input: ");
    uLCD.color(WHITE);
    uLCD.locate(8,2); uLCD.printf("%4.0f Hz",SpeakerFreq);
    uLCD.locate(10,4); uLCD.printf("%2.0f wpm",Speed);
    uLCD.locate(10,6); uLCD.printf("%2.0f",SpeakerVol*1000);
}

int main() {
// INITIAL SETTINGS AND DISPLAY
    // Set mode so that no external PullUp resistor is needed:
    pb1.mode(PullUp);
    pb2.mode(PullUp);
    pb3.mode(PullUp);
    pb4.mode(PullUp);
    pb5.mode(PullUp);
    pb6.mode(PullUp);
    wait(0.01); // Wait for mode to take effect.
    
    // Set up interrupt callback functions for a pb hit:
    pb1.attach_deasserted(&pb1_hit_callback);
    pb2.attach_deasserted(&pb2_hit_callback);
    pb3.attach_deasserted(&pb3_hit_callback);
    pb4.attach_deasserted(&pb4_hit_callback);
    pb5.attach_deasserted(&pb5_hit_callback);
    pb6.attach_deasserted(&pb6_hit_callback);
    
    // Sample pushbutton inputs using interrupts:
    pb1.setSampleFrequency();
    pb2.setSampleFrequency();
    pb3.setSampleFrequency();
    pb4.setSampleFrequency();
    pb5.setSampleFrequency();
    pb6.setSampleFrequency();
    
    // Set up LCD:
    uLCD.baudrate(3000000); // Set LCD to max baudrate.
    UpdateLCD();
    
    while(1) {
// INPUT TEXT USING SERIAL USB PORT
        pc.printf("\n========== MORSE CODE GENERATOR ==========\n");
        pc.printf("Type a sentence below (end with [.] or [?]):\n");
        
        char myChar = NULL;             // Initialize to save each character from port.
        char myString[100] = {NULL};    // Initialize to store concatenated characters. Set to 100 character limit for a sentence.
    
        while( !(myChar=='.' || myChar=='?') )
        {
            myChar = pc.getc(); // Read character from port.
            pc.putc( myChar );  // Echo character to port.
            sprintf(myString,"%s%c",myString,myChar); // Concatenate myString and myChar into myString.
        }
        
// DISPLAY TO LCD
        UpdateLCD();
        uLCD.color(GREEN);
        uLCD.locate(8,8); uLCD.printf("%s",myString);   // Display final input.
        
// TRANSLATE TEXT TO MORSE CODE
        pc.printf("\n\nTranslation:\n");
        int i = 0;                  // Initialize iterator.
        static char* X;             // Initialize output variable for Morse function.
        char myCode[1000] = {NULL}; // Initialize to store Morse code. This can get pretty big - set around 10 times the string length (Optimize this).
        char X2[50] = {NULL};       // Initialize to save X with or without spacing (leaving as X causes type-casting conflict).
        int SpaceDetect = 0;        // True if character is a space.
        
        while(myString[i] != '\0')
        {
            myChar = myString[i];               // Get each character.
            X = EncodeMorse(myChar);            // Translate it into Morse code.
    
            // Account for the spacing between letters in Morse code.
            if(i > 0)   // Is not the first letter in the code...
            {
                if(myChar != 32)    // Is not [Space]...
                {
                    if(SpaceDetect == 0)    // Is not a letter after [Space].
                    {
                        sprintf(X2,"%s%s",space,X); // Add spacing before letter.
                    }
                    else    // Is a letter after [Space].
                    {
                        sprintf(X2,"%s%s","",X);    // Don't add spacing before letter.
                        SpaceDetect = 0;            // Reset "space detected" flag
                    }
                }
                else    // Is [Space].
                {
                    sprintf(X2,"%s%s","",X);    // Don't add spacing.
                    SpaceDetect = 1;            // Enable to avoid adding spacing to the following letter.
                }
            }
            else    // Is the first letter in the code.
            {
                sprintf(X2,"%s%s","",X);        // Don't add spacing before the very first letter.
            }
            sprintf(myCode,"%s%s",myCode,X2);   // Concatenate into complete code.
            i++;                                // Get next character index.
            // DEBUGGING
            pc.printf("%c: %s -> %s\n",myChar,X,X2);
        }
        pc.printf("myCode = %s\n",myCode);      // Display code on PC. 
    
// PLAY MORSE CODE TO SPEAKER AND LED
        pc.printf("\nMorse code playback:\n");
        int j = 0;                  // Initialize iterator.
        int myInt;                  // Initialize for character to integer conversion.
        myChar = myCode[j];         // Initialize first character.
        while( myChar != NULL)
        {
            myInt = myChar - '0';    // Character to integer for numericals.
            if( myInt )
            {
                if(myInt==1) pc.printf(".");    // Display 1s as dots.
                if(myInt==3) pc.printf("-");    // Display 3s as dashes.
                led1 = 1;
                mySpeaker.PlayNote(SpeakerFreq,(myInt/Speed),SpeakerVol);
            }
            else
            {
                pc.printf(" ");     // Display 0s as spaces.
                led1 = 0;
                wait(1/Speed);
            }
            myChar = myCode[++j];   // Increment to next character.
        }
        // DEBUGGING
        pc.printf("\nmyString character length: %d\n",i);
        pc.printf("myCode character length: %d\n",j);
        led1 = 0;   // Turn LED off at the end because otherwise it stays on.
        pc.printf("[END]\n");
    } //infinite while loop
}//main