#include "mbed.h"
#include "rtos.h"
#include "string.h"
#include <stdio.h>
#include <ctype.h>
#include "TextLCD.h"
#include "SDBlockDevice.h"
#include "FATFileSystem.h"
#include "sample_hardware.hpp"
BusOut binaryOutput(A2, A3, A4);

//DigitalIn  onBoardSwitch(USER_BUTTON);
//DigitalIn  SW1(D12);
//DigitalIn  SW2(D13);
Serial pc(USBTX, USBRX);
Thread t1;  //thread used for thread one witch is the thread responsable for writeing and reading to the pcs serial port
Thread t2;  //thread used for reading the sensor data from bothe the enviromental sensor and the ldr
Thread t3;  // thread used to print to the lcd screen

//Thread ID for the Main function (CMSIS API)
osThreadId tidMain; // used only for setting up the main thread is not used after the initial setup and is set so sleep
osThreadId id1;  //used for thread one witch is the thread responsable for writeing and reading to the pcs serial port
osThreadId id2;   ///used for reading the sensor data from bothe the enviromental sensor and the ldr
osThreadId id3;// thread used to print to the lcd screen

SDBlockDevice sd(D11, D12, D13, D10); // mosi, miso, sclk, cs
    
TextLCD lcd(A1, A0, D6, D7, D8, D9); // rs, e, d4-d7 //TextLCD lcd(A1, A0, D6, D7, D8, D9); // rs, e, d4-d7
int waiting = 90;
float fLDR = 0.0;   //used to log the LDR level this has to be a global varable to be used in bothe threads
float temp = 0.0;       //used to log the tempreture and has to be global because it is used in two threads
float pressure = 0.0;   //used to log the presure and has to be global because it is used in two threads
int i=0;        // this is the number of samples taken from the last reset of the board
int j=0; // this is used to as a pointer for the sensor readings array
int k=0;  //used for the user to count the umber of printed cycles befor the used is asked what to do
int flag_for_debug =0;
float sensor_readings[101][4];      
void thread1() //serial comunnicaton and writeing to the LCD screen
{//create a varable for the recived data to print will also include the serial debbugger and when this is activaled thread must be called every 0.5 secconds
  pc.printf("if you would like to se all the infomation plese type Y into the keynord if you do not type n");  
  char choice = pc.getc(); 
   if(choice == 'y') {
            pc.printf("all the infomation will be shown\r\r\n");
            binaryOutput = 1;// this indicates that all of the infomation will be shown
        }else{
        pc.printf("only key infomation will be shown\r\r\n");
        binaryOutput =0;
        }  
if (k=100){
  pc.printf("if you would like to vuie or delete sensor data plese type Y into the keynord to delete the data if you do not type n to vuie all sensor\n\r\n");  
  char choice3 = pc.getc(); //gets the users choice 
   if(choice == 'y') {
            pc.printf("information in the array will now be deleted\r\r\n");
            delete[] sensor_readings;// this delets all the sensor readings
        }else{
        pc.printf("infomation in the array is still stored and is the following\r\r\n");
    int k=0;
    for (k=0; k<=101; k++){//for loop is used to increment the sensor
        pc.printf("\n\r");
        pc.printf("%f", sensor_readings[k][1]);//prints the reading id number
        pc.printf("\n\r");
        pc.printf("%f", sensor_readings[k][2]);//prints the ldr value
        pc.printf("\n\r");
        pc.printf("%f", sensor_readings[k][3]);//prints the tempreture value
        pc.printf("\n\r");
        pc.printf("%f", sensor_readings[k][4]);//prints the presure value
       } 
       k=0;//this is used so that once it reaches 101 sensor samples it will overite the first one saved and be a fifo 
       }
        }     
    
 pc.printf("plese type whitch sampling rate you would like a=10, b=100, c=200");
 char choice2 = pc.getc(); // reads in the used input
   if(choice2 == 'a') { //option for the choice as you can see from the prinf a sets it to 10
           if(choice == 'y') {
            pc.printf("you have sussesfully tested 10\r\r\n"); //conferms the users chice
        }
        waiting = 10;
        }
     if(choice2 == 'b'){
           if(choice == 'y') {//option for the choice as you can see from the prinf a sets it to 100
               pc.printf("you have sussesfully tested 100\r\r\n");//conferms the users chice
           }
        waiting = 100;
        }
    if(choice2 == 'c'){
            waiting = 200;
               if(choice == 'y') {//option for the choice as you can see from the prinf a sets it to 200
                  pc.printf("you have sussesfully tested 200\r\r\n");//conferms the users chice
                }
        };
        // aditinal if will alow the user to see and stop so they are sure of the sampling rate befor the start
       pc.printf("\n\r The sampleing rate is set to");      
       pc.printf("\n\r %i", waiting);  //prints out to the user what they have selected
       pc.printf(" nanoseconds \n");  
       pc.printf("\n\r press enter to continue");   
       choice2 = pc.getc();  // this means the user can look bak on anythin ther have typed before this
   while(1){
    i++;//increments the sample taken
    if(choice == 'y') {// this only gives some infor then
            pc.printf("\r\n\r\n");
            pc.printf("sample number %i \n\n\r", i);    // prints the sample number to the pc scree
        }         // prints all the values 
    pc.printf("tLDR = %6.4f\n\n\r", fLDR);      // prints the LDR reading to the screen
    pc.printf("temp = %6.4f\n\n\r", temp);      //prints the tempreture to the screen
    pc.printf("presure = %6.4f\n\n\r", pressure);   //prints the presure reading to the screen
    time_t seconds = time(NULL);            //sets up the timer
    //printf("Time as seconds since January 1, 1970 = %d\n", seconds); //prints the data
    //printf("Time as a basic string = %s", ctime(&seconds));// printe the seconds
    char buffer[32];
    strftime(buffer, 32, "%I:%M %p\n", localtime(&seconds)); //gatters the time in a custom format
    if (choice == 'y'){
        printf("Time as a custom formatted string = %s", buffer);   // prints the time
    }// if chouse is n there is no action taken
    if (choice == 'y'){
        pc.printf(" infomation has now been sent to the LCD screen \n\n\r");    // this will thell the user when the lcd screen has been updated
        flag_for_debug = 0; //resets the flag
    }// if chouse is n there is no action taken
    k++; // increments print no to the pc screen by one
   Thread::wait(1.5);// sleep for 1.5 seconds
   }
}

void thread2() 
{//this hapens in real time and is only blocked by the bottom where the time betwen samples is set from thread 1 or as a defult value of 90
  AnalogIn LDD_ADC_In(A5); //creates the anoalog input for the ldr ciurcit
  fLDR = 0.0;       //sets the LDr mesurement to 0
  fLDR = LDD_ADC_In;    // reads in the value from the LDR sensor
  temp     = sensor.getTemperature();    //reads in the tempreture into a global varable
  pressure = sensor.getPressure();       //reads in the presure into a gobal varable
  sensor_readings[i][0] =  i;           //saves the reading number to the array
  sensor_readings[i][1] =  fLDR;        //saves the LDR value to the array
  sensor_readings[i][2] =  temp;        //saves the tempreture reading to the array
  sensor_readings[i][3] =  pressure;        //saves the presure sensor to the array
  if (i==100){//checks to see if the records has reached 100
      i=0; //if the records has reached that i is set to 0 so it will start recording over the initial values
  }
Thread::wait(waiting); //this thread will then sleep for 15 secconds the sampleing rate should be acurete as the tread has nothing blocking in it
}
 void thread3() //used to write to the LCD screen only this mean that the code dose not waste time printing when it dose not need to 
 {  // global varable are used to print the sensor data so all LCD printing can happen in one threaad
   lcd.printf("the data last recived is...... \n");//this is for 11 need to use objects for the enviromental sensors(12)
   lcd.printf("tLDR = %6.4f\n\n\r", fLDR);      // prints the LDR reading to the screen
   lcd.printf("temp = %6.4f\n\n\r", temp);      //prints the tempreture to the screen
   lcd.printf("presure = %6.4f\n\n\r", pressure);   //prints the presure reading to the screen
   flag_for_debug = 1;//used by another tread to print to a pc screen that the sensors have been writen to the LCD screen
   Thread::wait(1.5);// sleep for 1.5 seconds     
 }
//Main thread
int main() {
       
TextLCD lcd(A1, A0, D6, D7, D8, D9);  //TextLCD lcd(A1, A0, D6, D7, D8, D9); // rs, e, d4-d7
    pc.baud(9600);// sets up a speed to comunicate through the comp port to the pc
    pc.printf("power on test\r\n");     // this prints to the pc serial port to ensure a conection is established for serial trasmition 
     lcd.printf("power on test\n"); //prints to the LCD screen this will make sure that it is working 

    t1.start(thread1);       //starts thread one    
    t2.start(thread2);      //starts thread two
     t3.start(thread3);     //starts thread 3
     
     id1 = t1.gettid();     // sets up tread identified
    id2 = t2.gettid();      //sets up thread identifier
    id3 = t3.gettid();      //sets up thread identifier
   
    while (true) {
        Thread::wait(osWaitForever);    // main thread is now not used ant it will let the other threads take over
    }

}

   
