#include "mbed.h"
#include "Trackball.h"


Trackball::Trackball(PinName pin_btn, PinName pin_lft, PinName pin_rht, PinName pin_up, PinName pin_dwn, PinName pin_wht, PinName pin_grn, PinName pin_red, PinName pin_blu)
    : _pin_btn(pin_btn), _pin_lft(pin_lft), _pin_rht(pin_rht), _pin_up(pin_up), _pin_dwn(pin_dwn), _pin_wht(pin_wht), _pin_grn(pin_grn), _pin_red(pin_red), _pin_blu(pin_blu)
{
       //initialize all LED pins to off.

    _pin_wht = 0;
    _pin_grn = 0;
    _pin_red = 0;
    _pin_blu = 0;

}

void Trackball::write(unsigned int val, int color)

    {
        if (color == color_WHITE){_pin_wht = val;}
        else if(color == color_BLUE){_pin_blu = val;}
        else if(color == color_GREEN){_pin_grn = val;}
        else if(color == color_RED){_pin_red = val;}
        else {printf("Invalid LED Color");}
    }
unsigned int Trackball::read(int dir)

    {
        unsigned int val;
        if(dir == dir_UP){val = _pin_up;}
        else if(dir == dir_DOWN){val = _pin_dwn;}
        else if(dir == dir_RIGHT){val = _pin_rht;}
        else if(dir == dir_LEFT){val = _pin_lft;}
        else if(dir == dir_BUTTON){val = _pin_btn;}
        return val;
        
    }